/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.tests;

import com.atlassian.bamboo.build.TestResultManager;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestCaseResultWrapper;
import com.atlassian.bamboo.results.tests.TestClassResult;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class TestClassResultWrapper
implements ResultStatisticsProvider {
    private static final Logger log = Logger.getLogger(TestClassResultWrapper.class);
    public static final String SUCCESS = "Successful";
    public static final String FAILED = "Failed";
    private TestClassResult testClassResult;
    private BuildResults buildResults;
    private TestResultManager testResultManager;
    private BuildState state;
    private Boolean existingFailure;
    private List wrappedTests;
    private List successfulTests;
    private List failedTests;

    public TestClassResultWrapper(TestClassResult testClassResult, BuildResults buildResults, TestResultManager testResultManager) {
        this.testResultManager = testResultManager;
        this.buildResults = buildResults;
        this.testClassResult = testClassResult;
    }

    public TestClassResult getTestClassResult() {
        return this.testClassResult;
    }

    public void setTestClassResult(TestClassResult testClassResult) {
        this.testClassResult = testClassResult;
    }

    public BuildResults getBuildResults() {
        return this.buildResults;
    }

    public void setBuildResults(BuildResults buildResults) {
        this.buildResults = buildResults;
    }

    public TestResultManager getTestResultManager() {
        return this.testResultManager;
    }

    public void setTestResultManager(TestResultManager testResultManager) {
        this.testResultManager = testResultManager;
    }

    public int getSuccessfulTestsCount() {
        return this.getSuccessfulTests().size();
    }

    public int getFailedTestsCount() {
        return this.getFailedTests().size();
    }

    public List getSuccessfulTests() {
        if (!this.isInit()) {
            this.initValues();
        }
        return this.successfulTests;
    }

    public List getFailedTests() {
        if (!this.isInit()) {
            this.initValues();
        }
        return this.failedTests;
    }

    public BuildState getBuildState() {
        if (!this.isInit()) {
            this.initValues();
        }
        return this.state;
    }

    public boolean hasExistingFailingTests() {
        if (!this.isInit()) {
            this.initValues();
        }
        return this.existingFailure;
    }

    public int getBuildNumber() {
        return this.buildResults.getBuildNumber();
    }

    public Date getBuildDate() {
        return this.buildResults.getStartTime();
    }

    public double getDurationInSeconds() {
        return this.getTotalDuration();
    }

    private boolean isInit() {
        return this.state != null && this.existingFailure != null && this.successfulTests != null && this.failedTests != null;
    }

    private void initValues() {
        List testResults = this.getTestResults();
        this.state = BuildState.SUCCESS;
        this.existingFailure = Boolean.FALSE;
        this.successfulTests = new ArrayList();
        this.failedTests = new ArrayList();
        for (TestCaseResultWrapper result : testResults) {
            if (BuildState.FAILED.equals(result.getBuildState())) {
                this.failedTests.add(result);
                this.state = BuildState.FAILED;
            }
            if (BuildState.SUCCESS.equals(result.getBuildState())) {
                this.successfulTests.add(result);
            }
            if (!result.isExistingFailure()) continue;
            this.existingFailure = Boolean.TRUE;
        }
    }

    public String getName() {
        return this.testClassResult.getName();
    }

    public String getShortName() {
        return this.testClassResult.getShortName();
    }

    public void addTestResult(TestResults testResult) {
        this.testClassResult.addTestResult(testResult);
    }

    public List getTestResults() {
        if (this.wrappedTests == null) {
            this.wrappedTests = this.testResultManager.wrapTestCaseResults(this.testClassResult.getTestResults(), this.buildResults);
        }
        return this.wrappedTests;
    }

    public double getTotalDuration() {
        return this.testClassResult.getTotalDuration();
    }

    public String getPrettyTotalDuration() {
        return this.testClassResult.getPrettyTotalDuration();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestClassResultWrapper)) {
            return false;
        }
        TestClassResultWrapper rhs = (TestClassResultWrapper)o;
        return this.testClassResult.equals(rhs.getTestClassResult());
    }

    public int compareTo(Object obj) {
        return this.testClassResult.compareTo(obj);
    }
}

