/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.configuration.CaptchaConfiguration;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.util.UrlUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdministrationConfiguration
implements Serializable {
    public static final String DEFAULT_URL = "http://localhost:8085";
    public static final int DEFAULT_BUILD_IN_QUEUE_TIMEOUT = 120;
    private String myBaseUrl = "http://localhost:8085";
    private boolean myUseGzipCompression = true;
    private boolean myEnableRemoteApi = true;
    private String myInstanceName;
    private BuildExpiryConfig myBuildExpiryConfiguration;
    private BuildHangingConfig myBuildHangingConfig;
    private ElasticConfiguration elasticConfig;
    private boolean enableSignup = true;
    private boolean enableAnonymousAccess = true;
    private boolean enableExternalUserManagement = false;
    private boolean enableViewContactDetails = false;
    private boolean enableRestrictedAdmin = false;
    private boolean remoteAgentFunctionEnabled = false;
    private CaptchaConfiguration captchaConfiguration;
    private ScheduleBackupConfiguration scheduleBackupConfiguration;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> globalVariables = new HashMap<String, String>();
    private int buildHangedInQueueNotificationTimeout = 120;

    public String getBaseUrl() {
        return UrlUtils.correctlyFormatUrl(this.myBaseUrl);
    }

    public void setBaseUrl(String baseUrl) {
        this.myBaseUrl = baseUrl;
    }

    public boolean isUseGzipCompression() {
        return this.myUseGzipCompression;
    }

    public void setUseGzipCompression(boolean useGzipCompression) {
        this.myUseGzipCompression = useGzipCompression;
    }

    public boolean isEnableSignup() {
        return this.enableSignup;
    }

    public void setEnableSignup(boolean enableSignup) {
        this.enableSignup = enableSignup;
    }

    public boolean isEnableAnonymousAccess() {
        return this.enableAnonymousAccess;
    }

    public void setEnableAnonymousAccess(boolean enableAnonymousAccess) {
        this.enableAnonymousAccess = enableAnonymousAccess;
    }

    public boolean isEnableExternalUserManagement() {
        return this.enableExternalUserManagement;
    }

    public CaptchaConfiguration getCaptchaConfiguration() {
        if (this.captchaConfiguration == null) {
            this.captchaConfiguration = new CaptchaConfiguration();
        }
        return this.captchaConfiguration;
    }

    public void setCaptchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this.captchaConfiguration = captchaConfiguration;
    }

    public void setEnableExternalUserManagement(boolean enableExternalUserManagement) {
        this.enableExternalUserManagement = enableExternalUserManagement;
    }

    public boolean isEnableViewContactDetails() {
        return this.enableViewContactDetails;
    }

    public void setEnableViewContactDetails(boolean enableViewContactDetails) {
        this.enableViewContactDetails = enableViewContactDetails;
    }

    public boolean isRemoteApiEnabled() {
        return this.myEnableRemoteApi;
    }

    public void setEnableRemoteApi(boolean enableRemoteApi) {
        this.myEnableRemoteApi = enableRemoteApi;
    }

    public void setBuildExpiryConfig(BuildExpiryConfig buildExpiryConfig) {
        this.myBuildExpiryConfiguration = buildExpiryConfig;
    }

    public BuildExpiryConfig getBuildExpiryConfig() {
        return this.myBuildExpiryConfiguration;
    }

    public ElasticConfiguration getElasticConfig() {
        return this.elasticConfig;
    }

    public void setElasticConfig(ElasticConfiguration elasticConfig) {
        this.elasticConfig = elasticConfig;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public void setSystemProperty(String key, String value) {
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap<String, String>();
        }
        this.systemProperties.put(key, value);
    }

    public String getSystemProperty(String key) {
        if (this.systemProperties == null) {
            return null;
        }
        return this.systemProperties.get(key);
    }

    public void setGlobalVariable(String key, String value) {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, String>();
        }
        this.globalVariables.put(key, value);
    }

    @Nullable
    public String getGlobalVariable(String key) {
        if (this.globalVariables == null) {
            return null;
        }
        return this.globalVariables.get(key);
    }

    public void removeGlobalVariable(String key) {
        if (this.globalVariables != null && this.globalVariables.containsKey(key)) {
            this.globalVariables.remove(key);
        }
    }

    @NotNull
    public Map<String, String> getGlobalVariables() {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, String>();
        }
        return this.globalVariables;
    }

    public ScheduleBackupConfiguration getScheduleBackupConfiguration() {
        return this.scheduleBackupConfiguration;
    }

    public void setScheduleBackupConfiguration(ScheduleBackupConfiguration scheduleBackupConfiguration) {
        this.scheduleBackupConfiguration = scheduleBackupConfiguration;
    }

    public String getInstanceName() {
        if (this.myInstanceName == null) {
            this.myInstanceName = "Atlassian Bamboo";
        }
        return this.myInstanceName;
    }

    public void setInstanceName(String instanceName) {
        this.myInstanceName = instanceName;
    }

    public boolean isRemoteAgentFunctionEnabled() {
        return this.remoteAgentFunctionEnabled;
    }

    public void setRemoteAgentFunctionEnabled(boolean enabled) {
        this.remoteAgentFunctionEnabled = enabled;
    }

    public BuildHangingConfig getBuildHangingConfig() {
        return this.myBuildHangingConfig;
    }

    public void setBuildHangingConfig(BuildHangingConfig myBuildHangingConfig) {
        this.myBuildHangingConfig = myBuildHangingConfig;
    }

    public int getBuildHangedInQueueNotificationTimeout() {
        if (this.buildHangedInQueueNotificationTimeout <= 0) {
            return 120;
        }
        return this.buildHangedInQueueNotificationTimeout;
    }

    public void setBuildHangedInQueueNotificationTimeout(int buildHangedInQueueNotificationTimeout) {
        this.buildHangedInQueueNotificationTimeout = buildHangedInQueueNotificationTimeout;
    }

    public boolean isEnableRestrictedAdmin() {
        return this.enableRestrictedAdmin;
    }

    public void setEnableRestrictedAdmin(boolean enableRestrictedAdmin) {
        this.enableRestrictedAdmin = enableRestrictedAdmin;
    }
}

