/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.xwork.TextProvider;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class BuildExpiryType {
    private static final Logger log = Logger.getLogger(BuildExpiryType.class);
    public static final BuildExpiryType ARTIFACT_BUILD_EXPIRY_TYPE = new BuildExpiryType("artifact");
    public static final BuildExpiryType RESULTS_BUILD_EXPIRY_TYPE = new BuildExpiryType("result");
    public static final List<BuildExpiryType> TYPES = Arrays.asList(ARTIFACT_BUILD_EXPIRY_TYPE, RESULTS_BUILD_EXPIRY_TYPE);
    private final String type;
    private TextProvider textProvider;

    public BuildExpiryType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.getTextProvider().getText("buildExpiry.enable.type." + this.type);
    }

    public String getDescription() {
        return this.getTextProvider().getText("buildExpiry.enable.type." + this.type + ".description");
    }

    public String getType() {
        return this.type;
    }

    public TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = (TextProvider)ContainerManager.getComponent((String)"textProvider");
        }
        return this.textProvider;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

