/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildExpiryConfig
implements Serializable {
    public static final String DAYS = "days";
    public static final String WEEKS = "weeks";
    public static final String MONTHS = "months";
    public static final String ARTIFACT_EXPIRY = "artifact";
    public static final String RESULTS_EXPIRY = "result";
    public static final String DEFAULT_CRON_EXPRESSION = "0 0 0 ? * *";
    private String myPeriod;
    private int myDuration;
    private int buildsToKeep;
    private String expiryType;
    private String excludeLabels;
    private String labelsToKeep;
    private String cronExpression;
    private boolean disabled = false;

    public BuildExpiryConfig() {
    }

    public BuildExpiryConfig(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public BuildExpiryConfig(int duration, String period) {
        this.myPeriod = period;
        this.myDuration = duration;
    }

    public BuildExpiryConfig(int duration, String period, int buildsToKeep) {
        this(duration, period);
        this.buildsToKeep = buildsToKeep;
    }

    public BuildExpiryConfig(String expiryType, int duration, String period, int buildsToKeep) {
        this(duration, period, buildsToKeep);
        this.expiryType = expiryType;
    }

    public BuildExpiryConfig(String expiryType, int duration, String period, int buildsToKeep, String excludeLabels, String labelsToKeep) {
        this(expiryType, duration, period, buildsToKeep);
        this.labelsToKeep = labelsToKeep;
        this.excludeLabels = excludeLabels;
    }

    public String getExpiryType() {
        return this.expiryType;
    }

    public void setExpiryType(String expiryType) {
        this.expiryType = expiryType;
    }

    public BuildExpiryType getBuildExpiryType() {
        if (ARTIFACT_EXPIRY.equals(this.expiryType)) {
            return BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE;
        }
        return BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE;
    }

    public String getPeriod() {
        return this.myPeriod;
    }

    public int getDuration() {
        return this.myDuration;
    }

    public int getBuildsToKeep() {
        return this.buildsToKeep;
    }

    public void setBuildsToKeep(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public void setPeriod(String myPeriod) {
        this.myPeriod = myPeriod;
    }

    public void setDuration(int myDuration) {
        this.myDuration = myDuration;
    }

    public boolean isExpireByDate() {
        return this.getDuration() > 0;
    }

    public boolean isExpireByBuild() {
        return this.getBuildsToKeep() > 0;
    }

    public String getLabelsToKeep() {
        return this.labelsToKeep;
    }

    public void setLabelsToKeep(String labelsToKeep) {
        this.labelsToKeep = labelsToKeep;
    }

    public String getExcludeLabels() {
        return this.excludeLabels;
    }

    public void setExcludeLabels(String excludeLabels) {
        this.excludeLabels = excludeLabels;
    }

    @NotNull
    public String getCronExpression() {
        if (this.cronExpression != null) {
            return this.cronExpression;
        }
        return DEFAULT_CRON_EXPRESSION;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public List<String> getLabelsList() {
        if (this.labelsToKeep == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(StringUtils.split((String)this.getLabelsToKeep(), (String)" ,"));
    }

    public Period getExpiryPeriod() {
        if (DAYS.equals(this.myPeriod)) {
            return Period.days((int)this.myDuration);
        }
        if (WEEKS.equals(this.myPeriod)) {
            return Period.weeks((int)this.myDuration);
        }
        if (MONTHS.equals(this.myPeriod)) {
            return Period.months((int)this.myDuration);
        }
        throw new IllegalStateException("\"" + this.myPeriod + "\" is an unknown period");
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean enabled) {
        this.disabled = enabled;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this).append("Builds to Keep", this.getBuildsToKeep()).append("Period", (Object)(this.getDuration() + " " + this.getPeriod()));
        if (Boolean.parseBoolean(this.getExcludeLabels())) {
            toStringBuilder.append("Labels to Keep", (Object)this.getLabelsToKeep());
        }
        return toStringBuilder.toString();
    }
}

