/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtils {
    private static final Logger log = Logger.getLogger(NumberUtils.class);
    private static final NumberUtils INSTANCE = new NumberUtils();

    private NumberUtils() {
    }

    public static NumberUtils getInstance() {
        return INSTANCE;
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static float round(float val, int places) {
        return (float)NumberUtils.round((double)val, places);
    }

    public static String padWithZeroes(Number value, int numberOfZeroes) {
        String pattern = NumberUtils.getPattern(numberOfZeroes);
        DecimalFormat stringNumberFormat = new DecimalFormat(pattern);
        return stringNumberFormat.format(value);
    }

    private static String getPattern(int numberOfZeroes) {
        String pattern = StringUtils.repeat((String)"0", (int)numberOfZeroes) + ".0#####";
        return pattern;
    }

    public static double stringToDouble(String s) {
        try {
            if (s != null) {
                return NumberFormat.getInstance().parse(s).doubleValue();
            }
            return 0.0;
        }
        catch (ParseException e) {
            log.warn((Object)e, (Throwable)e);
            return 0.0;
        }
    }

    public static long stringToLong(String s) {
        try {
            if (s != null) {
                return NumberFormat.getInstance().parse(s).longValue();
            }
            return 0L;
        }
        catch (ParseException e) {
            log.warn((Object)e, (Throwable)e);
            return 0L;
        }
    }

    public static int stringToInt(String s) {
        try {
            if (s != null) {
                return NumberFormat.getInstance().parse(s).intValue();
            }
            return 0;
        }
        catch (ParseException e) {
            log.warn((Object)e, (Throwable)e);
            return 0;
        }
    }

    public static <T extends Comparable<? super T>> T max(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The collection must not be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Collection cannot be empty.");
        }
        Comparable max = null;
        for (Comparable number : collection) {
            if (max != null && number.compareTo(max) <= 0) continue;
            max = number;
        }
        return (T)max;
    }

    public static boolean isPostiveInteger(@Nullable String input) {
        if (input == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(input);
            return i > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

