/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.repository.ChangeLogFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChangeLogEntry {
    public static final String UNKNOWN = "Unknown";
    private transient Date myDate;
    private String myAuthor;
    private String myComment;
    private List myChangedFiles;

    public ChangeLogEntry() {
        this.myChangedFiles = new ArrayList();
        this.myComment = "";
    }

    public ChangeLogEntry(String author, String comment, List changedFiles, Date data) {
        this.myDate = data;
        this.myAuthor = author;
        this.myComment = comment;
        this.myChangedFiles = changedFiles;
    }

    public Date getDate() {
        return this.myDate;
    }

    public void setDate(Date date) {
        this.myDate = date;
    }

    public String getAuthor() {
        if (this.myAuthor == null) {
            return UNKNOWN;
        }
        return this.myAuthor;
    }

    public void setAuthor(String author) {
        this.myAuthor = author;
    }

    public String getComment() {
        if (this.myComment == null) {
            return "";
        }
        return this.myComment.trim();
    }

    public void setComment(String comment) {
        this.myComment = comment;
    }

    public List getChangedFiles() {
        if (this.myChangedFiles == null) {
            return new ArrayList();
        }
        return this.myChangedFiles;
    }

    public void addFile(ChangeLogFile file) {
        this.myChangedFiles.add(file);
    }

    public void setFiles(List files) {
        this.myChangedFiles = files;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeLogEntry)) {
            return false;
        }
        ChangeLogEntry changeLogEntry = (ChangeLogEntry)o;
        if (this.myAuthor != null ? !this.myAuthor.equals(changeLogEntry.myAuthor) : changeLogEntry.myAuthor != null) {
            return false;
        }
        if (this.myChangedFiles != null ? !((Object)this.myChangedFiles).equals(changeLogEntry.myChangedFiles) : changeLogEntry.myChangedFiles != null) {
            return false;
        }
        if (this.myComment != null ? !this.myComment.equals(changeLogEntry.myComment) : changeLogEntry.myComment != null) {
            return false;
        }
        return !(this.myDate != null ? !this.myDate.equals(changeLogEntry.myDate) : changeLogEntry.myDate != null);
    }

    public int hashCode() {
        int result = this.myDate != null ? this.myDate.hashCode() : 0;
        result = 29 * result + (this.myAuthor != null ? this.myAuthor.hashCode() : 0);
        result = 29 * result + (this.myComment != null ? this.myComment.hashCode() : 0);
        result = 29 * result + (this.myChangedFiles != null ? ((Object)this.myChangedFiles).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "myDate = " + this.myDate + " myAuthor = " + this.myAuthor + " myComment = " + this.myComment + " myChangedFiles = " + this.myChangedFiles.size();
    }
}

