/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.build.BuildManager;
import com.atlassian.bamboo.buildqueue.manager.LocalAgentManager;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.set.ListOrderedSet;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorDetails {
    private final int errorNumber;
    private final String buildKey;
    private final String context;
    private final ThrowableDetails throwableDetails;
    private final Date firstOccurred;
    @GuardedBy(value="this")
    private final Set<Long> agentIds = new ListOrderedSet();
    private volatile Date lastOccurred;
    private volatile Integer buildNumber;
    private volatile int numberOfOccurrences = 1;
    private final BuildManager buildManager;
    private final LocalAgentManager localAgentManager;
    private final BuildResultsSummaryManager buildResultsSummaryManager;
    public static final String ALL_BUILDS = "All Builds";
    public static final String ELASTIC_BAMBOO = "Elastic Bamboo";

    public ErrorDetails(int errorNumber, String planKey, Integer buildNumber, @Nullable Long agentId, String context, Date timeStamp, ThrowableDetails throwableDetails, BuildManager buildManager, LocalAgentManager localAgentManager, BuildResultsSummaryManager buildResultsSummaryManager) {
        this.errorNumber = errorNumber;
        this.buildKey = planKey;
        this.context = context;
        this.throwableDetails = throwableDetails;
        this.firstOccurred = timeStamp;
        this.lastOccurred = timeStamp;
        this.buildNumber = buildNumber;
        this.buildManager = buildManager;
        this.localAgentManager = localAgentManager;
        this.buildResultsSummaryManager = buildResultsSummaryManager;
        if (agentId != null) {
            this.agentIds.add(agentId);
        }
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public String getBuildName() {
        Build build = this.buildManager.getBuildByKey(this.buildKey);
        if (build != null) {
            return build.getName();
        }
        return this.buildKey;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public String getBuildResultKey() {
        return this.buildKey + "-" + this.buildNumber;
    }

    public synchronized Set<Long> getAgentIds() {
        return this.agentIds;
    }

    public synchronized Collection<BuildAgent> getAgents() {
        return CollectionUtils.collect(this.getAgentIds(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ErrorDetails.this.localAgentManager.getAgent((Long)input);
            }
        });
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public String getContext() {
        return this.context;
    }

    public Date getLastOccurred() {
        return this.lastOccurred;
    }

    public Date getFirstOccurred() {
        return this.firstOccurred;
    }

    public int getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public ThrowableDetails getThrowableDetails() {
        return this.throwableDetails;
    }

    synchronized void recordOccurrence(Date timeStamp, Integer buildNumber, Long agentId) {
        ++this.numberOfOccurrences;
        if (agentId != null) {
            this.agentIds.add(agentId);
        }
        if (timeStamp != null && (this.lastOccurred == null || timeStamp.after(this.lastOccurred))) {
            this.lastOccurred = timeStamp;
        }
        if (buildNumber != null && (this.buildNumber == null || buildNumber > this.buildNumber)) {
            this.buildNumber = buildNumber;
        }
    }

    public boolean isBuildExists() {
        if (this.buildNumber == null) {
            return false;
        }
        ExtendedBuildResultsSummary buildResultsSummary = this.buildResultsSummaryManager.getBuildResultsSummary(this.buildKey, (int)this.buildNumber);
        return buildResultsSummary != null;
    }

    public boolean isForAllBuilds() {
        return ALL_BUILDS.equals(this.buildKey);
    }

    public boolean isBuildSpecific() {
        return !ALL_BUILDS.equals(this.buildKey) && this.buildKey != null;
    }

    public boolean isElastic() {
        return false;
    }
}

