/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.results.BuildResults;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class DeltaState
implements Serializable {
    private static final Logger log = Logger.getLogger(DeltaState.class);
    public static final DeltaState NONE = new DeltaState("NONE");
    public static final DeltaState PASSING = new DeltaState("PASSING");
    public static final DeltaState FAILING = new DeltaState("FAILING");
    public static final DeltaState BROKEN = new DeltaState("BROKEN");
    public static final DeltaState FIXED = new DeltaState("FIXED");
    private String deltaState;

    private DeltaState(String deltaState) {
        this.deltaState = deltaState;
    }

    public static DeltaState determineDeltaState(BuildState lastBuildState, BuildResults buildResults) {
        BuildState thisBuildState = buildResults.getBuildState();
        return DeltaState.determineDeltaState(lastBuildState, thisBuildState);
    }

    public static DeltaState determineDeltaState(BuildState lastBuildState, BuildState thisBuildState) {
        DeltaState deltaState = NONE;
        deltaState = BuildState.SUCCESS.equals(lastBuildState) ? (BuildState.SUCCESS.equals(thisBuildState) ? PASSING : BROKEN) : (BuildState.SUCCESS.equals(thisBuildState) ? FIXED : FAILING);
        return deltaState;
    }

    public static DeltaState getInstance(String deltaState) {
        if (PASSING.toString().equals(deltaState)) {
            return PASSING;
        }
        if (FAILING.toString().equals(deltaState)) {
            return FAILING;
        }
        if (BROKEN.toString().equals(deltaState)) {
            return BROKEN;
        }
        if (FIXED.toString().equals(deltaState)) {
            return FIXED;
        }
        return NONE;
    }

    public String toString() {
        return this.deltaState;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

