/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceListener;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelPorts;
import com.atlassian.bamboo.buildqueue.manager.LocalAgentManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ElasticInstanceManager
extends ElasticAgentTunnelPorts {
    public static final EC2InstanceType DEFAULT_INSTANCE_TYPE = EC2InstanceType.C1_MEDIUM;

    public RemoteElasticInstance newElasticAgent(RemoteElasticInstanceListener var1, AWSAccount var2, LocalAgentManager var3, ElasticImageConfiguration var4) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateException, UnrecoverableKeyException, KeyStoreException;

    public void ensureLoginKeyPairExists(AWSAccount var1) throws AWSException;

    public boolean validateAwsCredentials(String var1, String var2, ErrorCollection var3);

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgents();

    @NotNull
    public List<RemoteElasticInstance> getRequestedElasticRemoteAgents();

    public List<RemoteElasticInstance> getAllElasticRemoteAgents();

    public SetMultimap<ElasticImageConfiguration, RemoteElasticInstance> getAllElasticAgentsAsMap();

    public int getTotalNumElasticRemoteAgents();

    @Nullable
    public RemoteElasticInstance getElasticRemoteAgentByInstanceId(String var1);

    public void registerElasticAgentStopped(@NotNull RemoteElasticInstance var1);

    public void registerElasticAgentStarted(@NotNull RemoteElasticInstance var1);

    public void addElasticLogEntry(String var1);

    public List<String> getElasticAgentLogs();

    public boolean isElasticSupportEnabled();

    @NotNull
    public Set<EC2InstanceType> getAllowedInstanceTypes();

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgentsByConfiguration(ElasticImageConfiguration var1);

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgentsByConfiguration(long var1);

    @Nullable
    public String getDefaultImageId();
}

