/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DependencyBlockingStrategy {
    None("none", "build.dependency.strategy.none"),
    DontBuildIfParentInQueue("dont_build_if_parent_in_queue", "build.dependency.strategy.dontTriggerIfParentQueued"),
    BuildParentIfChangesDetected("dont_build_if_parent_in_queue_or_has_changes", "build.dependency.strategy.buildParentIfHasChanges");

    private static final String DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY = "custom.dependencies.trigger.remote.strategy";
    private final String value;
    private final String i18nKey;

    private DependencyBlockingStrategy(String value, String i18nKey) {
        this.value = value;
        this.i18nKey = i18nKey;
    }

    @Nullable
    public static DependencyBlockingStrategy getStrategy(@NotNull Build build) {
        if (build.getBuildDefinition().getCustomConfiguration() == null) {
            return null;
        }
        String value = build.getBuildDefinition().getCustomConfiguration().get(DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY);
        return DependencyBlockingStrategy.getByValue(value);
    }

    public static void setStrategy(DependencyBlockingStrategy strategy, @NotNull Build build) {
        if (build.getBuildDefinition().getCustomConfiguration() != null) {
            build.getBuildDefinition().getCustomConfiguration().put(DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY, strategy.value);
        }
    }

    public static DependencyBlockingStrategy getByValue(String value) {
        if (DependencyBlockingStrategy.DontBuildIfParentInQueue.value.equals(value)) {
            return DontBuildIfParentInQueue;
        }
        if (DependencyBlockingStrategy.BuildParentIfChangesDetected.value.equals(value)) {
            return BuildParentIfChangesDetected;
        }
        return None;
    }

    public static Map<String, String> getValueMap(@NotNull I18nBean i18nBean) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (DependencyBlockingStrategy strategy : DependencyBlockingStrategy.values()) {
            linkedHashMap.put(strategy.getValue(), i18nBean.getText(strategy.getI18nKey()));
        }
        return linkedHashMap;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public String getValue() {
        return this.value;
    }
}

