/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaVirtualMachineDetector {
    private static final Log LOGGER = LogFactory.getLog(JavaVirtualMachineDetector.class);
    private boolean myIsRunningOnOsx;

    public JavaVirtualMachineDetector(boolean isRunningOnOsx) {
        this.myIsRunningOnOsx = isRunningOnOsx;
    }

    public String detectJavaHome(String systemJavaHome) {
        if (!this.myIsRunningOnOsx && systemJavaHome != null) {
            File systemJavaHomeDirectory = new File(systemJavaHome);
            if (this.containsToolsJar(systemJavaHomeDirectory)) {
                return systemJavaHome;
            }
            File parentDirectory = systemJavaHomeDirectory.getParentFile();
            if (this.containsToolsJar(parentDirectory)) {
                return systemJavaHomeDirectory.getParent();
            }
        }
        return systemJavaHome;
    }

    public boolean containsToolsJar(File givenDirectory) {
        if (this.myIsRunningOnOsx) {
            return true;
        }
        File toolsJar = new File(givenDirectory, "lib" + File.separator + "tools.jar");
        try {
            return toolsJar.exists();
        }
        catch (Exception e) {
            LOGGER.info((Object)"Failed", (Throwable)e);
            return false;
        }
    }
}

