/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private static final Logger log = Logger.getLogger(CollectionUtils.class);
    private static final String listItemPattern = "\\[[^\\[\\]]*\\]";

    public static Collection stringToCollection(String s) {
        if (s == null || s.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        Pattern pattern = Pattern.compile(listItemPattern);
        Matcher matcher = pattern.matcher(s);
        ArrayList<String> toReturn = new ArrayList<String>();
        int foundUpTo = 0;
        while (matcher.find(foundUpTo)) {
            String item = matcher.group();
            item = StringUtils.replace((String)item, (String)"[", (String)"");
            item = StringUtils.replace((String)item, (String)"]", (String)"");
            toReturn.add(item);
            foundUpTo = matcher.end();
        }
        return toReturn;
    }

    public static List stringArrayToList(String[] s) {
        if (s == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> toReturn = new ArrayList<String>(s.length);
        for (int i = 0; i < s.length; ++i) {
            String s1 = s[i];
            toReturn.add(s1);
        }
        return toReturn;
    }

    public static List removeDuplicates(List input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return input;
        }
        HashSet set = new HashSet(input);
        ArrayList output = new ArrayList(set);
        return output;
    }

    public static List removeDuplicatesAndSort(List input, Comparator c) {
        List output = CollectionUtils.removeDuplicates(input);
        if (c != null) {
            Collections.sort(output, c);
        } else {
            Collections.sort(output);
        }
        return output;
    }

    public static List convertToList(String s) {
        if (s != null) {
            String[] strings = s.split(",");
            ArrayList<String> list = new ArrayList<String>(strings.length);
            for (int i = 0; i < strings.length; ++i) {
                String s1 = strings[i].trim();
                if (!StringUtils.isNotEmpty((String)s1)) continue;
                list.add(s1);
            }
            return list;
        }
        return null;
    }

    @Nullable
    public static String convertToString(Collection<String> collection) {
        return CollectionUtils.convertToString(collection, ", ");
    }

    @Nullable
    public static String convertToString(Collection<String> collection, String separator) {
        if (collection != null) {
            StringBuffer sb = new StringBuffer();
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                sb.append(s);
                if (!iterator.hasNext()) continue;
                sb.append(separator);
            }
            return sb.toString();
        }
        return null;
    }
}

