/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BuildResultsSummaryManager {
    @NotNull
    public List<ExtendedBuildResultsSummary> getAllBuildResultsSummaries(@NotNull Build var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getAllBuildResultsSummariesForAgent(@NotNull Long var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getAllFailedResultsSummaries(@NotNull Build var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getLastNFailedResultsSummaries(@NotNull Build var1, int var2);

    @NotNull
    public List<ExtendedBuildResultsSummary> getLastNBuildResultsSummaries(@NotNull Build var1, int var2);

    public BuildResultsSummary getBuildResultsSummaryById(long var1);

    public ExtendedBuildResultsSummary getBuildResultsSummary(String var1, int var2);

    public void saveBuildResultsSummary(BuildResultsSummary var1);

    public BuildResultsSummary generateSummaryFromBuildResults(BuildContext var1, CurrentlyBuilding var2, BuildResults var3);

    public BuildResultsSummary generateSummaryFromBuildResults(BuildContext var1, CurrentlyBuilding var2, BuildResults var3, Build var4);

    public BuildResultsSummary getFirstBuildSummary(Build var1);

    public ExtendedBuildResultsSummary getLastBuildSummary(Build var1);

    public long getNumberOfResults(Build var1);

    public ExtendedBuildResultsSummary getBuildResultsSummary(Build var1, int var2);

    public long getAverageBuildTime(@NotNull Build var1, int var2);

    public List getNeighbouringSummaries(Build var1, int var2);

    public void removeBuildResultsSummariesForBuild(@NotNull Build var1);

    public BuildResultsSummary getBreakingBuild(BuildResultsSummary var1);

    public List<ExtendedBuildResultsSummary> getLatestbuildResultSummaries();

    public List<ExtendedBuildResultsSummary> getLatestFailedBuildResultSummaries();

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummaries(@NotNull BuildResultsSummaryCriteria var1);

    public int countBuildResultsSummaries();

    public int countBuildResultsSummaries(@Nullable String var1);

    public void removeBuildResult(Build var1, int var2);

    public void removeArtifacts(Build var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastSuccessfulBuildSummary(@NotNull String var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getLatestSummariesForAgent(@NotNull Long var1);

    public ExtendedBuildResultsSummary getLastBuildSummary(String var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesByJiraIssues(@Nullable List<String> var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesByProjectKey(@Nullable String var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForBuildResults(@NotNull List<BuildResultsSummary> var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForBuild(@NotNull Build var1);

    @Nullable
    public ExtendedBuildResultsSummary getLastBuildForAgent(@NotNull String var1, @NotNull Long var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastSuccessfulBuildForAgent(@NotNull String var1, @NotNull Long var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastBuildForImageConfiguration(@NotNull String var1, @NotNull ElasticImageConfiguration var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastSuccessfulBuildForImageConfiguration(@NotNull String var1, @NotNull ElasticImageConfiguration var2);

    public int countBuildResultsSummariesForAgent(@NotNull BuildAgent var1);

    public int countFailedBuildResultsSummariesForAgent(@NotNull BuildAgent var1);
}

