/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.labels.Label;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultsSummaryCriteria
implements Cloneable {
    private static final Logger log = Logger.getLogger(BuildResultsSummaryCriteria.class);
    private String buildKey;
    private BuildState buildState;
    private Date fromDate;
    private Date toDate;
    private int fromBuildNumber;
    private int toBuildNumber;
    private Long agentId;
    private List<Label> matchesLabels;
    private int maxRowCount;
    private boolean sortAscending;

    public BuildResultsSummaryCriteria() {
    }

    public BuildResultsSummaryCriteria(String buildKey, Date fromDate, Date toDate) {
        this.buildKey = buildKey;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public BuildResultsSummaryCriteria(String buildKey, int fromBuildNumber, int toBuildNumber) {
        this.buildKey = buildKey;
        this.fromBuildNumber = fromBuildNumber;
        this.toBuildNumber = toBuildNumber;
    }

    public BuildResultsSummaryCriteria(String buildKey, Date fromDate, Date toDate, int fromBuildNumber, int toBuildNumber) {
        this.buildKey = buildKey;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.fromBuildNumber = fromBuildNumber;
        this.toBuildNumber = toBuildNumber;
    }

    public BuildResultsSummaryCriteria(String buildKey) {
        this.buildKey = buildKey;
    }

    public BuildResultsSummaryCriteria(String planKey, boolean sortAscending) {
        this.buildKey = planKey;
        this.sortAscending = sortAscending;
    }

    public BuildResultsSummaryCriteria(String planKey, int numberOfResults) {
        this.buildKey = planKey;
        this.maxRowCount = numberOfResults;
    }

    public BuildResultsSummaryCriteria(String planKey, BuildState buildState) {
        this.buildKey = planKey;
        this.buildState = buildState;
    }

    public BuildState getBuildState() {
        return this.buildState;
    }

    public void setBuildState(BuildState buildState) {
        this.buildState = buildState;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public int getFromBuildNumber() {
        return this.fromBuildNumber;
    }

    public int getToBuildNumber() {
        return this.toBuildNumber;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public List<Label> getMatchesLabels() {
        return this.matchesLabels;
    }

    public void setMatchesLabels(List<Label> matchesLabels) {
        this.matchesLabels = matchesLabels;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setFromBuildNumber(int fromBuildNumber) {
        this.fromBuildNumber = fromBuildNumber;
    }

    public Long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
    }

    public void setToBuildNumber(int toBuildNumber) {
        this.toBuildNumber = toBuildNumber;
    }

    public final BuildResultsSummaryCriteria clone() {
        try {
            BuildResultsSummaryCriteria clone = (BuildResultsSummaryCriteria)super.clone();
            if (this.matchesLabels != null) {
                clone.setMatchesLabels(Lists.newArrayList(this.matchesLabels));
            }
            return clone;
        }
        catch (Exception e) {
            log.warn((Object)("Unable to clone " + this), (Throwable)e);
            throw new RuntimeException("Unable to clone " + this, e);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getBuildKey()).append(this.getFromBuildNumber()).append(this.getToBuildNumber()).append((Object)this.getFromDate()).append((Object)this.getToDate()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildResultsSummaryCriteria)) {
            return false;
        }
        BuildResultsSummaryCriteria rhs = (BuildResultsSummaryCriteria)o;
        return new EqualsBuilder().append((Object)this.getBuildKey(), (Object)rhs.getBuildKey()).append(this.getFromBuildNumber(), rhs.getFromBuildNumber()).append(this.getToBuildNumber(), rhs.getToBuildNumber()).append((Object)this.getFromDate(), (Object)rhs.getFromDate()).append((Object)this.getToDate(), (Object)rhs.getToDate()).isEquals();
    }

    public int compareTo(Object obj) {
        BuildResultsSummaryCriteria o = (BuildResultsSummaryCriteria)obj;
        return new CompareToBuilder().append((Object)this.getBuildKey(), (Object)o.getBuildKey()).append(this.getFromBuildNumber(), o.getFromBuildNumber()).append(this.getToBuildNumber(), o.getToBuildNumber()).append((Object)this.getFromDate(), (Object)o.getFromDate()).append((Object)this.getToDate(), (Object)o.getToDate()).toComparison();
    }
}

