/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProject
extends BambooEntityObject
implements Project {
    private String key;
    protected String name;
    private List labellings;
    private List builds;

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public List<Build> getBuilds() {
        if (this.builds == null) {
            return Collections.EMPTY_LIST;
        }
        return this.builds;
    }

    public String getProjectSummary() {
        List<Build> list = this.getBuilds();
        return DefaultProject.getProjectSummaryForPlans(list);
    }

    public static String getProjectSummaryForPlans(Collection list) {
        int total = 0;
        int failed = 0;
        for (Build build : list) {
            ExtendedBuildResultsSummary summary;
            if (build.isSuspendedFromBuilding() || (summary = build.getLatestBuildSummary()) == null) continue;
            if (BuildState.FAILED.equals(summary.getBuildState())) {
                ++failed;
            }
            ++total;
        }
        if (failed > 0) {
            if (total == 1) {
                return "1 failed build plan";
            }
            return failed + " of " + total + " build plans failed";
        }
        if (total == 1) {
            return total + " successful build plan";
        }
        return total + " successful build plans";
    }

    @Override
    public String getCurrentStatus() {
        return DefaultProject.getCurrentStatusFromBuilds(this.builds);
    }

    public static String getCurrentStatusFromBuilds(Collection builds) {
        for (Build build : builds) {
            if (build.isSuspendedFromBuilding()) continue;
            String currentStatus = build.getCurrentStatus();
            if (currentStatus.equals("current")) {
                return "current";
            }
            if (!currentStatus.equals("fail")) continue;
            return "fail";
        }
        return "success";
    }

    public void setBuilds(List<? extends Build> builds) {
        this.builds = builds;
    }

    @Override
    public List getLabellings() {
        return this.labellings;
    }

    @Override
    public void setLabellings(List labellings) {
        this.labellings = labellings;
    }

    public int hashCode() {
        return new HashCodeBuilder(89, 11).append((Object)this.getKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultProject)) {
            return false;
        }
        DefaultProject rhs = (DefaultProject)o;
        return new EqualsBuilder().append((Object)this.getKey(), (Object)rhs.getKey()).isEquals();
    }

    public int compareTo(Object obj) {
        DefaultProject o = (DefaultProject)obj;
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).toComparison();
    }
}

