/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.util.HtmlUtils;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.jetbrains.annotations.NonNls;

public class SimpleLogEntry
implements LogEntry {
    @NonNls
    public static final String DATE_FORMAT_STRING = "dd-MMM-yyyy HH:mm:ss";
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"dd-MMM-yyyy HH:mm:ss");
    private static transient HtmlUtils htmlUtils = new HtmlUtils();
    private transient String cssClass;
    private Date time;
    private String log;

    public SimpleLogEntry(String log) {
        this(log, new Date());
    }

    public SimpleLogEntry(String log, Date time) {
        this.time = time;
        this.log = log;
    }

    public String getFormattedDate() {
        return this.time == null ? "" : DATE_FORMAT.format(this.time);
    }

    public Date getDate() {
        return this.time;
    }

    public String getLog() {
        return this.getHtmlUtils().getAsPreformattedText(this.log);
    }

    public String getCssStyle() {
        return null;
    }

    public String getUnstyledLog() {
        return this.log;
    }

    public String toString() {
        return this.getUnstyledLog();
    }

    private HtmlUtils getHtmlUtils() {
        if (htmlUtils == null) {
            htmlUtils = new HtmlUtils();
        }
        return htmlUtils;
    }

    public void setHtmlUtils(HtmlUtils htmlUtils) {
        SimpleLogEntry.htmlUtils = htmlUtils;
    }
}

