/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.security.acegi.acls.HibernateAcl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BuildManager {
    public void removeDependencies(Build var1);

    @Nullable
    public Build getBuildByKey(String var1);

    public Build getBuildById(long var1);

    public Collection<Build> getAllBuilds();

    public Collection<Build> getAllBuildsForRead();

    public Collection<Build> retreiveAllBuilds();

    public Collection<Build> getAllBuildsForEdit();

    public Collection<Build> getAllBuildsForClone();

    public Collection<Build> getBuildsForDeletion();

    public Collection getBuildsByProjectForRead(Project var1);

    public Collection<Project> getAllProjects();

    public Project getProjectByKey(String var1);

    public Project getProjectById(long var1);

    public boolean isExistingBuildName(String var1);

    public boolean isExistingBuildKey(String var1);

    public boolean isExistingProjectName(String var1);

    public boolean isExistingProjectKey(String var1);

    public boolean isExistingBuildName(String var1, String var2);

    public boolean isExistingBuildKey(String var1, String var2);

    public void createBuild(Build var1, BuildConfiguration var2, HibernateAcl var3);

    public void saveBuild(Build var1);

    public void saveBuildAndDefinition(Build var1);

    public void saveBuildConfig(Build var1, BuildConfiguration var2);

    public void deleteBuild(String var1);

    public void deleteProject(Project var1);

    public void addBuildResults(Build var1, BuildResults var2);

    public BuildResults getBuildResults(Build var1, Integer var2);

    public int retrieveNextBuildNumber(String var1);

    public void recordLastBuildNumber(Build var1, BuildResultsSummary var2, BuildContext var3);

    public void addChildBuild(Build var1, String var2);

    public Project getProjectByName(String var1);

    public Build getBuildByProjectAndName(String var1, String var2);

    public void updateNames(String var1, String var2, Build var3);

    public void updateLatestVcsKey(@NotNull String var1, @NotNull String var2);

    public boolean isAllowBuilding(@NotNull String var1);
}

