/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FilteredMap
implements Map {
    private final String prefix;
    private final Map decoratedMap;

    public FilteredMap(String prefix) {
        this.prefix = prefix;
        this.decoratedMap = new HashMap();
    }

    public FilteredMap(String prefix, Map decoratedMap) {
        this.prefix = prefix + ".";
        this.decoratedMap = decoratedMap;
    }

    public FilteredMap subset(String prefix) {
        return new FilteredMap(prefix, this.decoratedMap);
    }

    public int size() {
        return this.decoratedMap.size();
    }

    public boolean isEmpty() {
        return this.decoratedMap.isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.decoratedMap.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.decoratedMap.containsKey(this.prefix + key);
    }

    public Object get(Object key) {
        return this.decoratedMap.get(this.prefix + key);
    }

    public Object put(Object key, Object value) {
        return this.decoratedMap.put(this.prefix + key, value);
    }

    public Object remove(Object key) {
        return this.decoratedMap.remove(this.prefix + key);
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        return this.decoratedMap.values();
    }

    public Set entrySet() {
        return this.decoratedMap.entrySet();
    }

    public boolean equals(Object o) {
        return ((Object)this.decoratedMap).equals(o);
    }

    public Map getDecoratedMap() {
        return this.decoratedMap;
    }

    public static FilteredMap decorate(String prefix, Map params) {
        return new FilteredMap(prefix, params);
    }
}

