/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.util.Date;
import org.joda.time.Period;

public class DurationUtils {
    private static final float MILLIS_IN_HOUR = 3600000.0f;
    private static final float MILLIS_IN_MINUTE = 60000.0f;
    private static final float MILLIS_IN_SECOND = 1000.0f;
    public static final String PRIOR_TEXT = "before";
    public static final String AGO = "ago";

    public static String getPrettyPrint(long elapsedTimeMillis, boolean isLong) {
        float elapsedTimeSec;
        float elapsedTimeMin;
        if ((float)elapsedTimeMillis >= 60000.0f && (elapsedTimeMin = (float)elapsedTimeMillis / 60000.0f) > 0.0f) {
            return DurationUtils.describeValueAs((int)elapsedTimeMin, isLong ? " minute" : " min");
        }
        if ((float)elapsedTimeMillis >= 1000.0f && (elapsedTimeSec = (float)elapsedTimeMillis / 1000.0f) > 0.0f) {
            return DurationUtils.describeValueAs((int)elapsedTimeSec, isLong ? " second" : " sec");
        }
        return isLong ? "less than 1 second" : "< 1 sec";
    }

    public static long getNormalizedTime(long elapsedTimeMillis) {
        float elapsedTimeSec;
        float elapsedTimeMin;
        if ((float)elapsedTimeMillis >= 60000.0f && (elapsedTimeMin = (float)elapsedTimeMillis / 60000.0f) > 0.0f) {
            return (long)((float)((int)elapsedTimeMin) * 60000.0f);
        }
        if ((float)elapsedTimeMillis >= 1000.0f && (elapsedTimeSec = (float)elapsedTimeMillis / 1000.0f) > 0.0f) {
            return (long)((float)((int)elapsedTimeSec) * 1000.0f);
        }
        return elapsedTimeMillis;
    }

    public static String getPrettyPrint(long elapsedTimeMillis) {
        return DurationUtils.getPrettyPrint(elapsedTimeMillis, true);
    }

    public static String getRelativeDate(Date fromDate) {
        return DurationUtils.getRelativeDate(fromDate, new Date());
    }

    public static String getRelativeDate(long fromDate) {
        return DurationUtils.getRelativeDate(new Date(fromDate), new Date());
    }

    public static String getRelativeDate(Date fromDate, Date comparedTo) {
        Period period = new Period(fromDate.getTime(), comparedTo.getTime());
        StringBuffer buffer = new StringBuffer();
        int years = period.getYears();
        if (years > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, years, " year");
        }
        int months = period.getMonths();
        if (months > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, months, " month");
        }
        int weeks = period.getWeeks();
        if (weeks > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, weeks, " week");
        }
        int days = period.getDays();
        if (days > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, days, " day");
        }
        int hours = period.getHours();
        if (hours > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, hours, " hour");
        }
        int minutes = period.getMinutes();
        if (minutes > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, minutes, " minute");
        }
        int seconds = period.getSeconds();
        if (seconds > 0) {
            return DurationUtils.formatRelativeDateItem(buffer, seconds, " second");
        }
        return "< 1 second";
    }

    private static String formatRelativeDateItem(StringBuffer buffer, int numberOfItems, String item) {
        buffer.append(numberOfItems).append(item);
        if (numberOfItems > 1) {
            buffer.append("s");
        }
        return buffer.toString();
    }

    private static String describeValueAs(int value, String as) {
        String result = value + as;
        if (value > 1) {
            result = result + 's';
        }
        return result;
    }
}

