/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HtmlUtils {
    private static final Logger log = Logger.getLogger(HtmlUtils.class);
    public static final String WBR = "&#8203;";
    public static final String BSLASH = "&#92;";

    public String getAsPreformattedText(Object o) {
        if (o == null) {
            return "";
        }
        String s = o instanceof String ? (String)o : o.toString();
        s = StringEscapeUtils.escapeHtml((String)s);
        s = s.replaceAll("(\\n|\\r\\n)", "<br\\>$1");
        s = this.whiteSpacePreWrap(s);
        return s;
    }

    private String whiteSpacePreWrap(String s) {
        s = s.replaceAll("  ", "&nbsp; ");
        s = s.replaceAll("  ", " &nbsp;");
        s = s.replaceAll("(\\t)", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        s = s.replaceAll("\\\\", BSLASH);
        return s;
    }

    public String getTextAsHtml(Object o) {
        if (o == null) {
            return "";
        }
        String s = o instanceof String ? (String)o : o.toString();
        s = TextUtils.plainTextToHtml((String)s);
        s = this.whiteSpacePreWrap(s);
        return s;
    }

    public String getFirstNLines(String s, int lines) {
        if (s == null) {
            return "";
        }
        s = StringUtils.replace((String)s, (String)"\r\n", (String)"\n");
        int numberOfLines = 0;
        int newlineChar = 0;
        int lastValidIndex = s.length();
        while (numberOfLines < lines && newlineChar != -1) {
            if ((newlineChar = StringUtils.indexOf((String)s, (String)"\n", (int)newlineChar)) == -1) continue;
            lastValidIndex = newlineChar++;
            ++numberOfLines;
        }
        if (numberOfLines < lines) {
            return s;
        }
        return s.substring(0, lastValidIndex);
    }

    public String getFirstNLinesWithTrailer(String s, int lines) {
        int totalNumberOfLines = StringUtils.countMatches((String)s, (String)"\n");
        if (!s.endsWith("\n")) {
            ++totalNumberOfLines;
        }
        String showingLines = this.getFirstNLines(s, lines);
        if (totalNumberOfLines > lines) {
            int difference = totalNumberOfLines - lines;
            return showingLines + "\n(" + difference + " more lines...)";
        }
        return showingLines;
    }

    public String appendUrls(String url1, String url2) {
        if (url1.endsWith("/") && url2.startsWith("/")) {
            return url1 + url2.substring(1);
        }
        return url1 + url2;
    }

    public String encodeUrl(String url) {
        String result;
        try {
            result = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Url encoding operation is unsupported.");
            return url;
        }
        return result;
    }

    public String addPrefixToLines(String prefix, String input) {
        return prefix + input.replaceAll("\n", "\n" + prefix);
    }
}

