/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BambooDateUtils {
    private static final SimpleDateFormat PORTABLE_DATE_FORMAT = new SimpleDateFormat("'portable' G yyyy-MM-dd HH:mm:ss.SSS Z", Locale.ENGLISH);

    public static boolean isWithinDays(Date earlierDate, Date laterDate, long days) {
        long daysDifference = (laterDate.getTime() - earlierDate.getTime()) / 86400000L;
        if (daysDifference < 0L) {
            throw new IllegalArgumentException("LaterDate must be later than the first date");
        }
        return daysDifference < days;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToPortableString(Date date) {
        SimpleDateFormat simpleDateFormat = PORTABLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return PORTABLE_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date portableDateToString(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = PORTABLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return PORTABLE_DATE_FORMAT.parse(dateString);
        }
    }
}

