/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.tests;

import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.core.util.collection.EasyList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class TestClassResult {
    private final String name;
    private final List testResults;
    private String cachedTotalDuration;

    public TestClassResult(String name) {
        this.name = name;
        this.testResults = new ArrayList();
    }

    public TestClassResult(TestResults testResults) {
        this.name = testResults.getClassName();
        this.testResults = EasyList.build((Object)testResults);
    }

    public TestClassResult(List testResults) {
        TestResults first = (TestResults)testResults.get(0);
        this.name = first.getClassName();
        this.testResults = new ArrayList();
        for (TestResults testResult : testResults) {
            this.addTestResult(testResult);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.getName();
    }

    public String getShortName() {
        if (StringUtils.contains((String)this.getName(), (String)".")) {
            return StringUtils.substringAfterLast((String)this.getName(), (String)".");
        }
        return this.getName();
    }

    public void addTestResult(TestResults testResult) {
        if (testResult == null || this.name != null && !this.name.equals(testResult.getClassName())) {
            throw new IllegalArgumentException("Name of testResults must match that of the TestClassResult.");
        }
        this.testResults.add(testResult);
    }

    public List getTestResults() {
        return this.testResults;
    }

    public double getTotalDuration() {
        double totalDuration = 0.0;
        for (TestResults results : this.testResults) {
            totalDuration += results.getDurationInSeconds();
        }
        return totalDuration;
    }

    public String getPrettyTotalDuration() {
        if (this.cachedTotalDuration == null) {
            this.cachedTotalDuration = DurationUtils.getPrettyPrint((long)(this.getTotalDuration() * 1000.0));
        }
        return this.cachedTotalDuration;
    }

    public int hashCode() {
        return new HashCodeBuilder(83, 11).append((Object)this.getName()).append((Object)this.getTestResults()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestClassResult)) {
            return false;
        }
        TestClassResult rhs = (TestClassResult)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getTestResults(), (Object)rhs.getTestResults()).isEquals();
    }

    public int compareTo(Object obj) {
        TestClassResult o = (TestClassResult)obj;
        return new CompareToBuilder().append((Object)this.getName(), (Object)o.getName()).append((Object)this.getTestResults(), (Object)o.getTestResults()).toComparison();
    }
}

