/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results;

import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.build.Artifact;
import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.build.BuildManager;
import com.atlassian.bamboo.builder.BuildProgressBar;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestClassResult;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.results.tests.TestResultsSummary;
import com.atlassian.bamboo.results.tests.TestResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.InitialBuildTriggerReason;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultsImpl
implements BuildResults {
    private static final Logger log = Logger.getLogger(BuildResultsImpl.class);
    private volatile transient BuildManager buildManager;
    private volatile transient BuildResultsSummaryManager buildResultsSummaryManager;
    private transient String buildKey;
    private transient StopWatch stopWatch;
    private transient File mySourceDirectory;
    private transient BuildProgressBar progressBar;
    private Map customBuildInfo;
    private transient Map successfulTestResultsByClass;
    private transient Map failedTestResultsByClass;
    private transient BuildChanges buildChanges;
    private transient int buildReturnCode;
    private transient TestResultsSummary testResults;
    private transient Set<Commit> commits;
    private ReasonForBuild myReasonForBuild;
    private BuildState myBuildState;
    private List<String> myBuildErrors;
    private int myBuildNumber;
    private List mySuccessfulTestResults;
    private List myFailedTestResults;
    private Date myBuildDate;
    private long myBuildDuration;
    private Map<String, Artifact> myArtifacts;
    private transient Collection myChangeList;
    private transient BuildResultsSummary buildResultsSummary;
    private transient String myBuildName;
    private transient String myProjectName;
    private transient List myBuildOutput;
    private transient List buildLog;

    public BuildResultsImpl() {
    }

    public BuildResultsImpl(String buildKey, BuildState state, List<String> buildErrors, Collection<Commit> commits, ReasonForBuild reasonForBuild, Map<String, Artifact> artifacts) {
        this.buildKey = buildKey;
        this.myBuildState = state;
        this.myBuildErrors = buildErrors;
        if (commits != null) {
            this.commits = new LinkedHashSet<Commit>(commits);
        }
        this.myReasonForBuild = reasonForBuild;
        this.myArtifacts = artifacts;
    }

    @Override
    public Build getBuild() {
        if (this.getBuildManager() == null) {
            throw new IllegalStateException("getBuild called without the container being injected");
        }
        return this.getBuildManager().getBuildByKey(this.getBuildKey());
    }

    @Override
    public BuildChanges getBuildChanges() {
        return this.buildChanges;
    }

    @Override
    public void setBuildChanges(BuildChanges buildChanges) {
        this.buildChanges = buildChanges;
    }

    @Override
    public String getBuildKey() {
        return this.buildKey;
    }

    @Override
    public String getFullKey() {
        return this.getBuildKey() + "-" + this.getBuildNumber();
    }

    @Override
    public ExtendedBuildResultsSummary getBuildResultsSummary() {
        BuildResultsSummaryManager buildResultsSummaryManager = this.getBuildResultsSummaryManager();
        ExtendedBuildResultsSummary summary = buildResultsSummaryManager.getBuildResultsSummary(this.getBuild(), this.getBuildNumber());
        return summary;
    }

    public BuildResultsSummaryManager getBuildResultsSummaryManager() {
        if (this.buildResultsSummaryManager == null) {
            this.buildResultsSummaryManager = (BuildResultsSummaryManager)ContainerManager.getComponent((String)"buildResultsSummaryManager");
        }
        return this.buildResultsSummaryManager;
    }

    public void setBuildResultsSummaryManager(BuildResultsSummaryManager buildResultsSummaryManager) {
        this.buildResultsSummaryManager = buildResultsSummaryManager;
    }

    @Override
    public void setStartTime(Date date) {
        this.myBuildDate = date;
    }

    @Override
    public Date getStartTime() {
        if (this.myBuildDate == null) {
            this.myBuildDate = new Date();
        }
        return this.myBuildDate;
    }

    @Override
    public Date getBuildCompletedTimeStamp() {
        return new Date(this.getStartTime().getTime() + this.getBuildDurationInMilliseconds());
    }

    @Override
    public void setDurationInMilliseconds(long buildDuration) {
        this.myBuildDuration = buildDuration;
    }

    @Override
    public long getBuildDurationInMilliseconds() {
        return this.myBuildDuration;
    }

    @Override
    public BuildState getBuildState() {
        return this.myBuildState;
    }

    @Override
    public void setBuildState(@NotNull BuildState buildState) {
        this.myBuildState = buildState;
    }

    @Override
    public void addBuildErrors(List<String> errorMessages) {
        if (errorMessages != null) {
            this.getBuildErrors().addAll(errorMessages);
        }
    }

    @Override
    public List<String> getBuildErrors() {
        if (this.myBuildErrors == null) {
            this.myBuildErrors = new ArrayList<String>();
        }
        return this.myBuildErrors;
    }

    public void setBuildErrors(List<String> buildErrors) {
        this.myBuildErrors = buildErrors;
    }

    @Override
    public void setTestResults(Set<TestResults> successfulTestResults, Set<TestResults> failedTestResults) {
        this.setSuccessfulTestResults(new ArrayList<TestResults>(successfulTestResults));
        this.setFailedTestResults(new ArrayList<TestResults>(failedTestResults));
    }

    @Override
    public BuildResults cloneAsBuildResults(BuildContext buildContext, ReasonForBuild reasonForBuild) {
        HashMap<String, Artifact> artifactsMap = new HashMap<String, Artifact>();
        Collection<Artifact> artifacts = buildContext.getBuildPlanDefinition().getArtifactDefinitions();
        for (Artifact artifact : artifacts) {
            artifactsMap.put(artifact.getLabel(), artifact);
        }
        BuildResultsImpl buildResults = new BuildResultsImpl(buildContext.getPlanKey(), this.getBuildState(), this.getBuildErrors(), null, reasonForBuild, artifactsMap);
        buildResults.setBuildNumber(buildContext.getBuildNumber());
        buildResults.setBuildManager(this.getBuildManager());
        buildResults.setBuildChanges(buildContext.getBuildChanges());
        buildResults.setDurationInMilliseconds(this.getBuildDurationInMilliseconds());
        buildResults.setStartTime(this.getStartTime());
        buildResults.setSuccessfulTestResults(this.getSuccessfulTestResults());
        buildResults.setFailedTestResults(this.getFailedTestResults());
        Map<String, String> clonedCustomData = buildResults.getCustomBuildData();
        Map<String, String> customData = this.getCustomBuildData();
        if (customData != null) {
            for (Map.Entry<String, String> customDataEntry : customData.entrySet()) {
                clonedCustomData.put(customDataEntry.getKey(), customDataEntry.getValue());
            }
        }
        return buildResults;
    }

    @Override
    public void setBuildNumber(int buildNumber) {
        this.myBuildNumber = buildNumber;
        this.getCustomBuildData().put("buildNumber", Integer.toString(buildNumber));
    }

    @Override
    public int getBuildNumber() {
        return this.myBuildNumber;
    }

    public List getFailedTestResults() {
        return this.myFailedTestResults;
    }

    @Override
    public boolean hasFailedTests() {
        return this.myFailedTestResults != null && !this.myFailedTestResults.isEmpty();
    }

    @Override
    public int getFailedTestCount() {
        return (int)this.getListSize(this.myFailedTestResults);
    }

    private long getListSize(List list) {
        if (list != null) {
            return list.size();
        }
        return 0L;
    }

    @Override
    public void setFailedTestResults(List failedTestResults) {
        this.myFailedTestResults = failedTestResults;
    }

    public List getSuccessfulTestResults() {
        return this.mySuccessfulTestResults;
    }

    @Override
    public boolean hasSuccessfulTests() {
        return this.mySuccessfulTestResults != null && !this.mySuccessfulTestResults.isEmpty();
    }

    @Override
    public Collection getSuccessfulTestResultsByClass() {
        if (this.successfulTestResultsByClass == null) {
            this.successfulTestResultsByClass = new ListOrderedMap();
            this.populateTestResultsByClass(this.successfulTestResultsByClass, this.getSuccessfulTestResults());
        }
        return this.successfulTestResultsByClass.values();
    }

    @Override
    public Collection getFailedTestResultsByClass() {
        if (this.failedTestResultsByClass == null) {
            this.failedTestResultsByClass = new ListOrderedMap();
            this.populateTestResultsByClass(this.failedTestResultsByClass, this.getFailedTestResults());
        }
        return this.failedTestResultsByClass.values();
    }

    @Override
    public Map getFailedTestResultsByClassAsMap() {
        if (this.failedTestResultsByClass == null) {
            this.failedTestResultsByClass = new ListOrderedMap();
            this.populateTestResultsByClass(this.failedTestResultsByClass, this.getFailedTestResults());
        }
        return this.failedTestResultsByClass;
    }

    @Override
    public int getSuccessfulTestCount() {
        return (int)this.getListSize(this.mySuccessfulTestResults);
    }

    @Override
    public int getTestCount() {
        return this.getSuccessfulTestCount() + this.getFailedTestCount();
    }

    @Override
    public void setSuccessfulTestResults(List successfulTestResults) {
        this.mySuccessfulTestResults = successfulTestResults;
    }

    @Override
    public ReasonForBuild getReasonForBuild() {
        return this.myReasonForBuild;
    }

    @Override
    public void setReasonForBuild(ReasonForBuild reasonForBuild) {
        this.myReasonForBuild = reasonForBuild;
    }

    @Override
    public Map<String, Artifact> getArtifacts() {
        return this.myArtifacts;
    }

    @Override
    public void setArtifacts(Map<String, Artifact> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Override
    @NotNull
    public Map<String, String> getCustomBuildData() {
        if (this.customBuildInfo == null) {
            this.customBuildInfo = new HashMap();
            this.customBuildInfo.put("buildNumber", Integer.toString(this.getBuildNumber()));
            this.customBuildInfo.put("buildKey", this.buildKey);
        }
        return this.customBuildInfo;
    }

    @Override
    public void setCustomBuildData(Map<String, String> customBuildData) {
        this.customBuildInfo = customBuildData;
    }

    @Override
    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    @Override
    public double getSuccessfulTestDuration() {
        List successfulTestResults = this.getSuccessfulTestResults();
        if (successfulTestResults == null) {
            return 0.0;
        }
        double totalDuration = 0.0;
        for (int i = 0; i < successfulTestResults.size(); ++i) {
            TestResults testResult = (TestResults)successfulTestResults.get(i);
            totalDuration += testResult.getDurationInSeconds();
        }
        return totalDuration;
    }

    @Override
    public String getSuccessfulTestDurationAsText() {
        return DurationUtils.getPrettyPrint((long)(this.getSuccessfulTestDuration() * 1000.0));
    }

    private void populateTestResultsByClass(Map testResultsByClass, List testResults) {
        if (testResults != null) {
            for (TestResults results : testResults) {
                String className = results.getClassName();
                TestClassResult testClassResult = (TestClassResult)testResultsByClass.get(className);
                if (testClassResult == null) {
                    testClassResult = new TestClassResult(className);
                }
                testClassResult.addTestResult(results);
                testResultsByClass.put(className, testClassResult);
            }
        }
    }

    @Override
    public int getBuildReturnCode() {
        return this.buildReturnCode;
    }

    @Override
    public void setBuildReturnCode(int buildReturnCode) {
        this.buildReturnCode = buildReturnCode;
    }

    @Override
    public Set<Author> getUniqueAuthors() {
        Set<Commit> commits = this.getCommits();
        ListOrderedSet uniqueAuthors = new ListOrderedSet();
        if (commits != null) {
            for (Commit commit : commits) {
                uniqueAuthors.add(commit.getAuthor());
            }
        }
        return uniqueAuthors;
    }

    @Override
    public synchronized Set<Commit> getCommits() {
        if (this.commits == null) {
            this.commits = this.getBuildResultsSummary().getCommits();
            this.commits.isEmpty();
        }
        return this.commits;
    }

    @Override
    public TestResultsSummary getTestResults() {
        if (this.testResults == null) {
            this.testResults = new TestResultsSummaryImpl(this.getSuccessfulTestResults(), this.getFailedTestResults(), this);
        }
        return this.testResults;
    }

    @Override
    public BuildResults getPreviousBuildResults() {
        return this.getBuild().getPreviousBuildResults(this.getBuildNumber());
    }

    @Override
    public BuildResults getNextBuildResults() {
        return this.getBuild().getNextBuildResults(this.getBuildNumber());
    }

    @Override
    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    @Override
    public boolean isCurrentlyQueuedOnly() {
        return this.getBuildNumber() == 0;
    }

    @Override
    public StopWatch getStopWatch() {
        if (this.stopWatch == null) {
            this.stopWatch = new StopWatch();
        }
        return this.stopWatch;
    }

    public void startTimer() {
        this.getStopWatch().start();
    }

    public void stopTimer() {
        StopWatch stopWatch = this.getStopWatch();
        stopWatch.stop();
        this.setDurationInMilliseconds(stopWatch.getTime());
    }

    @Override
    public void clearBuildErrors() {
        this.getBuildErrors().clear();
    }

    @Override
    public long getBuildTime() {
        return this.getStopWatch().getTime();
    }

    @Override
    public String getPrettyBuildTime() {
        return DurationUtils.getPrettyPrint(this.getBuildTime());
    }

    @Override
    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public String getBuildResultsKey() {
        return this.getBuildKey() + "-" + this.getBuildNumber();
    }

    public String toString() {
        return "BuildResults: " + this.getBuildResultsKey();
    }

    public BuildManager getBuildManager() {
        if (this.buildManager == null) {
            this.buildManager = (BuildManager)ContainerManager.getComponent((String)"buildManager");
        }
        return this.buildManager;
    }

    public static ReasonForBuild getReasonForBuild(BuildContext buildContext) {
        TriggerReason reason = buildContext.getTriggerReason();
        if (reason instanceof ManualBuildTriggerReason) {
            return ReasonForBuild.MANUAL_BUILD;
        }
        if (reason instanceof DependencyTriggerReason) {
            return ReasonForBuild.DEPENDENCY_BUILD;
        }
        if (reason instanceof InitialBuildTriggerReason) {
            return ReasonForBuild.INITIAL_CLEAN_BUILD;
        }
        return ReasonForBuild.CODE_HAS_CHANGED;
    }
}

