/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.aws.ec2.EC2PrivateKey;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.spring.container.ContainerManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdministrationConfiguration
implements Serializable {
    public static final String DEFAULT_URL = "http://localhost:8085";
    public static final int DEFAULT_POLLING_PERIOD = 120;
    private String mySmtpServer;
    private String myBaseUrl = "http://localhost:8085";
    private String myBuildDirectory = "build-dir";
    private String myEmailPrefix = "[Bamboo]";
    private String myEmailFromAddress = "bamboo@atlassian.com";
    private int myRepositoryPollingPeriod = 120;
    private boolean myUseGzipCompression;
    private Map myJdks = new HashMap();
    private String myLicense;
    private boolean myEnableRemoteApi;
    private String myInstanceName;
    private BuildExpiryConfig myBuildExpiryConfiguration;
    private BuildHangingConfig myBuildHangingConfig;
    private boolean enableSignup = true;
    private boolean enableAnonymousAccess = true;
    private boolean enableExternalUserManagement = false;
    private boolean enableViewContactDetails = false;
    private boolean remoteAgentFunctionEnabled = false;
    private ScheduleBackupConfiguration scheduleBackupConfiguration;
    private Map systemProperties = new HashMap();
    private Map<String, String> globalVariables = new HashMap<String, String>();
    private transient AdminErrorHandler adminErrorHandler;
    private EC2PrivateKey privateKey;

    public String getSmtpServer() {
        return this.mySmtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.mySmtpServer = smtpServer;
    }

    public String getBaseUrl() {
        return UrlUtils.correctlyFormatUrl(this.myBaseUrl);
    }

    public void setBaseUrl(String baseUrl) {
        this.myBaseUrl = baseUrl;
    }

    public boolean isInitialised() {
        return this.myLicense != null;
    }

    public String getEmailPrefix() {
        return this.myEmailPrefix;
    }

    public void setEmailPrefix(String emailPrefix) {
        this.myEmailPrefix = emailPrefix;
    }

    public String getEmailFromAddress() {
        return this.myEmailFromAddress;
    }

    public void setEmailFromAddress(String emailAddress) {
        this.myEmailFromAddress = emailAddress;
    }

    public int getDefaultRepositoryPollingPeriod() {
        if (this.myRepositoryPollingPeriod <= 0) {
            return 120;
        }
        return this.myRepositoryPollingPeriod;
    }

    public void setDefaultRepositoryPollingPeriod(int repositoryPollingPeriod) {
        this.myRepositoryPollingPeriod = repositoryPollingPeriod;
    }

    public String getBuildDirectory() {
        return this.myBuildDirectory;
    }

    public void setBuildDirectory(String buildDirectory) {
        this.myBuildDirectory = buildDirectory;
    }

    public boolean isUseGzipCompression() {
        return this.myUseGzipCompression;
    }

    public void setUseGzipCompression(boolean useGzipCompression) {
        this.myUseGzipCompression = useGzipCompression;
    }

    public String getLicense() {
        return this.myLicense;
    }

    public void setLicense(String license) {
        this.myLicense = license;
    }

    public boolean isEnableSignup() {
        return this.enableSignup;
    }

    public void setEnableSignup(boolean enableSignup) {
        this.enableSignup = enableSignup;
    }

    public boolean isEnableAnonymousAccess() {
        return this.enableAnonymousAccess;
    }

    public void setEnableAnonymousAccess(boolean enableAnonymousAccess) {
        this.enableAnonymousAccess = enableAnonymousAccess;
    }

    public boolean isEnableExternalUserManagement() {
        return this.enableExternalUserManagement;
    }

    public void setEnableExternalUserManagement(boolean enableExternalUserManagement) {
        this.enableExternalUserManagement = enableExternalUserManagement;
    }

    public boolean isEnableViewContactDetails() {
        return this.enableViewContactDetails;
    }

    public void setEnableViewContactDetails(boolean enableViewContactDetails) {
        this.enableViewContactDetails = enableViewContactDetails;
    }

    public boolean isRemoteApiEnabled() {
        return this.myEnableRemoteApi;
    }

    public void setEnableRemoteApi(boolean enableRemoteApi) {
        this.myEnableRemoteApi = enableRemoteApi;
    }

    public void setBuildExpiryConfig(BuildExpiryConfig buildExpiryConfig) {
        this.myBuildExpiryConfiguration = buildExpiryConfig;
    }

    public BuildExpiryConfig getBuildExpiryConfig() {
        return this.myBuildExpiryConfiguration;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    private AdminErrorHandler getAdminErrorHandler() {
        if (this.adminErrorHandler == null) {
            this.adminErrorHandler = (AdminErrorHandler)ContainerManager.getComponent((String)"adminErrorHandler");
        }
        return this.adminErrorHandler;
    }

    public void setSystemProperty(String key, String value) {
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap();
        }
        this.systemProperties.put(key, value);
    }

    public String getSystemProperty(String key) {
        if (this.systemProperties == null) {
            return null;
        }
        return (String)this.systemProperties.get(key);
    }

    public void setGlobalVariable(String key, String value) {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, String>();
        }
        this.globalVariables.put(key, value);
    }

    @Nullable
    public String getGlobalVariable(String key) {
        if (this.globalVariables == null) {
            return null;
        }
        return this.globalVariables.get(key);
    }

    public void removeGlobalVariable(String key) {
        if (this.globalVariables != null && this.globalVariables.containsKey(key)) {
            this.globalVariables.remove(key);
        }
    }

    @NotNull
    public Map<String, String> getGlobalVariables() {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, String>();
        }
        return this.globalVariables;
    }

    public ScheduleBackupConfiguration getScheduleBackupConfiguration() {
        return this.scheduleBackupConfiguration;
    }

    public void setScheduleBackupConfiguration(ScheduleBackupConfiguration scheduleBackupConfiguration) {
        this.scheduleBackupConfiguration = scheduleBackupConfiguration;
    }

    public String getInstanceName() {
        if (this.myInstanceName == null) {
            this.myInstanceName = "Atlassian Bamboo";
        }
        return this.myInstanceName;
    }

    public void setInstanceName(String instanceName) {
        this.myInstanceName = instanceName;
    }

    public boolean isRemoteAgentFunctionEnabled() {
        return this.remoteAgentFunctionEnabled;
    }

    public void setRemoteAgentFunctionEnabled(boolean enabled) {
        this.remoteAgentFunctionEnabled = enabled;
    }

    public BuildHangingConfig getBuildHangingConfig() {
        return this.myBuildHangingConfig;
    }

    public void setBuildHangingConfig(BuildHangingConfig myBuildHangingConfig) {
        this.myBuildHangingConfig = myBuildHangingConfig;
    }

    public void setEC2LoginPrivateKey(EC2PrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

