/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo;

import java.io.Serializable;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ReasonForBuild
implements Serializable {
    private String myReason;
    private static final String INITIAL_CLEAN_BUILD_STRING = "Initial clean build";
    public static final ReasonForBuild INITIAL_CLEAN_BUILD = new ReasonForBuild("Initial clean build");
    private static final String CODE_HAS_CHANGED_STRING = "Code has changed";
    public static final ReasonForBuild CODE_HAS_CHANGED = new ReasonForBuild("Code has changed");
    private static final String MANUAL_BUILD_STRING = "Manual build";
    public static final ReasonForBuild MANUAL_BUILD = new ReasonForBuild("Manual build");
    private static String DEPENDENCY_BUILD_STRING = "Dependency build";
    public static final ReasonForBuild DEPENDENCY_BUILD = new ReasonForBuild(DEPENDENCY_BUILD_STRING);
    private static String BUILD_HAS_BEEN_EDITED_STRING = "Project edited";
    public static final ReasonForBuild BUILD_HAS_BEEN_EDITED = new ReasonForBuild(BUILD_HAS_BEEN_EDITED_STRING);
    private static String SCHEDULED_BUILD_STRING = "Scheduled build";
    public static final ReasonForBuild SCHEDULED_BUILD = new ReasonForBuild(SCHEDULED_BUILD_STRING);

    private ReasonForBuild(String reason) {
        this.myReason = reason;
    }

    public static ReasonForBuild getReasonForBuild(String reason) {
        if (INITIAL_CLEAN_BUILD_STRING.equals(reason)) {
            return INITIAL_CLEAN_BUILD;
        }
        if (CODE_HAS_CHANGED_STRING.equals(reason)) {
            return CODE_HAS_CHANGED;
        }
        if (MANUAL_BUILD_STRING.equals(reason)) {
            return MANUAL_BUILD;
        }
        if (DEPENDENCY_BUILD_STRING.equals(reason)) {
            return DEPENDENCY_BUILD;
        }
        if (BUILD_HAS_BEEN_EDITED_STRING.equals(reason)) {
            return BUILD_HAS_BEEN_EDITED;
        }
        if (SCHEDULED_BUILD_STRING.equals(reason)) {
            return SCHEDULED_BUILD;
        }
        return null;
    }

    public String getReason() {
        return this.myReason;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReasonForBuild)) {
            return false;
        }
        ReasonForBuild rhs = (ReasonForBuild)o;
        return new EqualsBuilder().append((Object)this.getReason(), (Object)rhs.getReason()).isEquals();
    }

    public int compareTo(Object obj) {
        ReasonForBuild o = (ReasonForBuild)obj;
        return new CompareToBuilder().append((Object)this.getReason(), (Object)o.getReason()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 51).append((Object)this.getReason()).toHashCode();
    }

    public String toString() {
        return this.myReason;
    }
}

