/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic;

import com.atlassian.bamboo.agent.elastic.ElasticAgentUserData;
import com.atlassian.bamboo.agent.elastic.ElasticAgentUserDataImpl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ElasticAgentUserDataMetadataHelper {
    private static final String META_AWS_ASSEMBLY_LOCATION = "aws.agentAssemblyLocation";
    private static final String META_VERSION_SPECIFIC_DATA_LOCATION = "bamboo.version.specific.data.location";
    private static final String META_INSTANCE_SPECIFIC_DATA_LOCATIONS = "bamboo.instance.specific.data.locations";
    private static final String AGENT_INSTALLER_COMMAND = "agent.installer.command";
    private static final String META_AWS_ACCESS_KEY = "aws.accessKey";
    private static final String META_AWS_SECRET_KEY = "aws.secretKey";
    private static final String META_FINGERPRINT = "bamboo.server.fingerprint";
    private static final String STARTUP_SCRIPT = "startupScript";
    private static final String SPACE = ":SpAcE:";

    private ElasticAgentUserDataMetadataHelper() {
    }

    public static void setInstallerRunCommand(Map<String, String> metaData, Iterable<String> args) {
        if (args == null || !args.iterator().hasNext()) {
            metaData.remove(AGENT_INSTALLER_COMMAND);
            return;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> argsIt = args.iterator();
        while (argsIt.hasNext()) {
            String arg = argsIt.next();
            sb.append(arg);
            if (!argsIt.hasNext()) continue;
            sb.append(SPACE);
        }
        metaData.put(AGENT_INSTALLER_COMMAND, sb.toString());
    }

    public static List<String> getInstallerRunCommand(ElasticAgentUserDataImpl userData) {
        String s = ElasticAgentUserDataMetadataHelper.getMetaData(userData).get(AGENT_INSTALLER_COMMAND);
        if (s == null) {
            return null;
        }
        return Arrays.asList(s.split(SPACE));
    }

    public static void setAwsAccessKey(Map<String, String> metaData, String awsAccessKey) {
        metaData.put(META_AWS_ACCESS_KEY, awsAccessKey);
    }

    public static void setAwsSecretKey(Map<String, String> metaData, String awsSecretKey) {
        metaData.put(META_AWS_SECRET_KEY, awsSecretKey);
    }

    public static String getFingerprint(Map<String, String> metaData) {
        return metaData.get(META_FINGERPRINT);
    }

    public static void setFingerprint(Map<String, String> metaData, String fingerprint) {
        metaData.put(META_FINGERPRINT, fingerprint);
    }

    public static String getAssemblyLocation(ElasticAgentUserData userData) {
        return ElasticAgentUserDataMetadataHelper.getMetaData(userData).get(META_AWS_ASSEMBLY_LOCATION);
    }

    public static void setBootstrapLocation(Map<String, String> metaData, String value) {
        metaData.put(META_AWS_ASSEMBLY_LOCATION, value);
    }

    public static String getVersionSpecificDataLocation(ElasticAgentUserData userData) {
        return ElasticAgentUserDataMetadataHelper.getMetaData(userData).get(META_VERSION_SPECIFIC_DATA_LOCATION);
    }

    public static void setVersionSpecificDataLocation(Map<String, String> metaData, String value) {
        metaData.put(META_VERSION_SPECIFIC_DATA_LOCATION, value);
    }

    public static String getInstanceSpecificDataLocations(ElasticAgentUserData userData) {
        return ElasticAgentUserDataMetadataHelper.getMetaData(userData).get(META_INSTANCE_SPECIFIC_DATA_LOCATIONS);
    }

    public static void setInstanceSpecificDataLocations(Map<String, String> metaData, String value) {
        metaData.put(META_INSTANCE_SPECIFIC_DATA_LOCATIONS, value);
    }

    public static void addScript(Map<String, String> metaData, String script, int i) {
        metaData.put(ElasticAgentUserDataMetadataHelper.getIndexedKey(STARTUP_SCRIPT, i), script);
    }

    public static LinkedList<String> getStartupScripts(Map<String, String> metaData) {
        LinkedList<String> startupScripts = new LinkedList<String>();
        for (int i = 0; i < 32; ++i) {
            String startupScript = ElasticAgentUserDataMetadataHelper.getStartupScript(metaData, i);
            if (startupScript.isEmpty()) continue;
            startupScripts.add(startupScript);
        }
        return startupScripts;
    }

    private static Map<String, String> getMetaData(ElasticAgentUserData userData) {
        Map<String, String> metaData = userData.getMetaData();
        if (metaData == null) {
            throw new NullPointerException("Metadata not found in user data");
        }
        return metaData;
    }

    private static String getStartupScript(Map<String, String> metaData, int i) {
        String script = metaData.get(ElasticAgentUserDataMetadataHelper.getIndexedKey(STARTUP_SCRIPT, i));
        return script != null ? script : "";
    }

    private static String getIndexedKey(String keyStem, int i) {
        return keyStem + "_" + i;
    }
}

