/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.bootstrap.Agent;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.elastic.client.ElasticAgent;
import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteAgent;
import com.atlassian.bamboo.v2.build.agent.remote.UpgradeRemoteAgent;
import com.atlassian.security.utils.ConstantTimeComparison;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.Lazy;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AgentServerManagerImpl
implements AgentServerManager {
    private static final Logger log = Logger.getLogger(AgentServerManagerImpl.class);
    private static final String ELASTIC_AGENT_TYPE = "elastic";
    private final ServerFingerprint fingerprint;
    private final Supplier<Map<String, String>> userProperties = Lazy.supplier((Supplier)new Supplier<Map<String, String>>(){

        @Override
        public Map<String, String> get() {
            ImmutableMap.Builder userPropertiesBuilder = ImmutableMap.builder();
            userPropertiesBuilder.putAll(AgentServerManagerImpl.this.constantUserProperties);
            try {
                Certificate certificate = AgentServerManagerImpl.this.broker.getCertificate();
                if (certificate != null) {
                    userPropertiesBuilder.put((Object)"bamboo.agent.brokerCertificate", (Object)Base64.getUrlEncoder().encodeToString(certificate.getEncoded()));
                }
            }
            catch (Exception e) {
                log.warn((Object)"Unable to retrieve certificate from the keystore, ActiveMQ SSL connections from agents may not work: ", (Throwable)e);
            }
            return userPropertiesBuilder.build();
        }
    });
    private final BambooBrokerService broker;
    private final Map<String, String> constantUserProperties;

    public AgentServerManagerImpl(BootstrapManager bootstrapManager, BambooBrokerService broker, Map<String, String> userProperties) {
        this.broker = broker;
        this.constantUserProperties = userProperties;
        this.fingerprint = bootstrapManager.getFingerprint();
    }

    @Override
    public boolean isServerFingerprintValid(@Nullable String serverFingerprint) {
        return serverFingerprint != null && ConstantTimeComparison.isEqual((String)this.fingerprint.getServerFingerprint(), (String)serverFingerprint);
    }

    @Override
    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public ServerFingerprint getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public Class<? extends Agent> getAgentClass(String agentType, String agentBootstrapVersion) {
        if (!ELASTIC_AGENT_TYPE.equals(agentType)) {
            String serverBootstrapVersion = "4";
            return "4".equals(agentBootstrapVersion) ? RemoteAgent.class : UpgradeRemoteAgent.class;
        }
        return ElasticAgent.class;
    }

    @Override
    public Map<String, String> getUserProperties() {
        return this.userProperties.get();
    }
}

