/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.bootstrap.Agent;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.elastic.client.ElasticAgent;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteAgent;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentServerManagerImpl
implements AgentServerManager {
    private final String fingerprint;
    private final Map<Object, Object> userProperties;

    public AgentServerManagerImpl(BootstrapManager bootstrapManager, Map<Object, Object> userProperties) throws NoSuchAlgorithmException {
        this.fingerprint = bootstrapManager.getFingerprint();
        this.userProperties = userProperties;
    }

    @Override
    public boolean isFingerprintValid(String fingerprint) {
        return this.fingerprint.equals(fingerprint);
    }

    @Override
    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public Class<? extends Agent> getAgentClass(String agentType) {
        return "elastic".equals(agentType) ? ElasticAgent.class : RemoteAgent.class;
    }

    @Override
    public Map<Object, Object> getUserProperties() {
        return this.userProperties;
    }
}

