/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.BambooHttpUtils;
import com.atlassian.bamboo.agent.bootstrap.AgentIdInitializer;
import com.atlassian.bamboo.agent.bootstrap.AgentRunner;
import com.atlassian.bamboo.agent.bootstrap.AgentUuidInitializer;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUpdater;
import com.atlassian.bamboo.agent.bootstrap.ClasspathBuilder;
import com.atlassian.bamboo.agent.bootstrap.GetFingerprintResponse;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpException;
import com.atlassian.bamboo.agent.bootstrap.classloading.ClassLoaderUtils;
import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentHttpClientFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentContext
implements Serializable {
    private static final Logger log = Logger.getLogger(AgentContext.class);
    public static final String SERVER_AUTH_POLL_INTERVAL = "bamboo.agent.auth.pollInterval";
    public static final String SERVER_FINGERPRINT_PARAM = "fingerprint";
    public static final String INSTANCE_FINGERPRINT_PARAM = "instanceFingerprint";
    public static final String VERSION_PARAM = "version";
    public static final String UUID_PARAM = "agentUuid";
    public static final String AGENT_ID_PARAM = "agentId";
    public static final String SECURITY_TOKEN_PARAM = "securityToken";
    public static final String DISABLE_BOOTSTRAP_UPDATE = "disableBootstrapUpdate";
    public static final String APPROVAL_REQUIRED_HEADER = "ApprovalRequired";
    public static final String BOOTSTRAP_VERSION = "4";
    private final URL baseUrl;
    private final String fingerPrintRequestSuffix;
    private final AgentType agentBootstrapType;
    private final long serverPollInterval;
    private final UUID agentUuid;
    private final Long agentId;
    private final RemoteAgentHttpClientFactory httpClientFactory;
    @Nullable
    private final String securityToken;
    private transient CloseableHttpClient httpClient;
    private volatile String agentClassName;
    private volatile String serverFingerprint;
    private volatile long instanceFingerprint;
    private volatile Map<String, String> userProperties;

    public AgentContext(RemoteAgentHttpClientFactory httpClientFactory, @NotNull URL baseUrl, String fingerPrintRequestSuffix, AgentType agentBootstrapType, @Nullable String securityToken) throws MalformedURLException {
        this.httpClientFactory = httpClientFactory;
        this.securityToken = securityToken;
        this.baseUrl = this.withTrailingSlash(baseUrl);
        this.fingerPrintRequestSuffix = fingerPrintRequestSuffix;
        this.agentBootstrapType = agentBootstrapType;
        this.serverPollInterval = Long.getLong(SERVER_AUTH_POLL_INTERVAL, 60L);
        AgentUuidInitializer uuidInitializer = new AgentUuidInitializer();
        this.agentUuid = uuidInitializer.initUuid();
        this.agentId = new AgentIdInitializer().initAgentId();
    }

    private URL withTrailingSlash(URL baseUrl) throws MalformedURLException {
        return baseUrl.getPath().endsWith("/") ? baseUrl : new URL(baseUrl + "/");
    }

    protected void run() throws IOException {
        this.initServerSession();
        log.info((Object)("Bootstrap Type: [" + this.agentBootstrapType + "], agent class: " + this.agentClassName));
        log.info((Object)"Preparing for a classloader switch");
        ClassLoader classLoader = this.newClassLoader();
        Thread thread = ClassLoaderUtils.newThreadWithIsolatedClassloader(classLoader, AgentRunner.class, new Serializable[]{this, this.agentClassName});
        thread.setName("AgentRunnerThread");
        log.info((Object)"--==Switching to the new classloader==--");
        thread.start();
    }

    private void initServerSession() throws IOException {
        this.initFingerprint();
        this.updateBootstrapIfNecessary(this.agentBootstrapType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initFingerprint() throws IOException {
        fingerprintRequestUrl = this.createFingerprintUrl(this.getHostname());
        AgentContext.log.info((Object)("Requesting fingerprint, url: " + fingerprintRequestUrl));
        block8: do {
            method = new HttpGet(fingerprintRequestUrl);
            method.addHeader("X-Atlassian-Token", "no-check");
            try {
                httpClient = this.getHttpClient();
                AgentContext.log.info((Object)("Authenticating against Bamboo server at " + this.baseUrl));
                response = httpClient.execute((HttpUriRequest)method);
                statusCode = response.getStatusLine().getStatusCode();
                switch (statusCode) {
                    case 200: {
                        AgentContext.log.info((Object)"Successfully authenticated with Bamboo server");
                        fingerprintResponse = new GetFingerprintResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
                        this.validateBootstrapVersion(fingerprintResponse);
                        this.serverFingerprint = fingerprintResponse.getServerFingerprint();
                        this.instanceFingerprint = fingerprintResponse.getInstanceFingerprint();
                        this.agentClassName = fingerprintResponse.getAgentClassName();
                        this.userProperties = fingerprintResponse.getUserProperties();
                        ** break;
lbl21:
                        // 1 sources

                        continue block8;
                    }
                    case 400: {
                        entity = response.getEntity();
                        serverMessage = entity != null ? EntityUtils.toString((HttpEntity)entity) : "NO_MESSAGE";
                        AgentContext.log.error((Object)this.logStrings(new String[]{"An error occurred while contacting the server. Message from the server is:", serverMessage, "Agent will now shut down."}));
                        System.exit(1);
                    }
                    case 401: {
                        entity = response.getEntity();
                        v0 = serverMessage = entity != null ? EntityUtils.toString((HttpEntity)entity) : "NO_MESSAGE";
                        if (response.getHeaders("ApprovalRequired").length > 0) {
                            AgentContext.log.warn((Object)this.logStrings(new String[]{"This agent requires manual approval.", "UUID: " + this.agentUuid, "Message from the server is:", serverMessage, String.format("Next authentication attempt in %d seconds... ", new Object[]{this.serverPollInterval})}));
                            this.haveSomeSleep();
                            ** break;
lbl34:
                            // 1 sources

                        } else {
                            AgentContext.log.error((Object)this.logStrings(new String[]{"Agent authentication failed. Message from the server is:", serverMessage, "Agent will now shut down."}));
                            System.exit(1);
                            ** break;
                        }
lbl38:
                        // 1 sources

                        continue block8;
                    }
                    default: {
                        AgentContext.log.error((Object)("An error has occurred when requesting fingerprint: " + response.getStatusLine()));
                        AgentContext.log.debug((Object)BambooHttpUtils.entityToString(response));
                        throw new RemoteAgentHttpException(response.getStatusLine(), "fingerprint");
                    }
                }
            }
            finally {
                method.releaseConnection();
            }
        } while (statusCode != 200);
    }

    private String logStrings(String ... logs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n********************************************************************************\n");
        sb.append("*\n");
        for (String s : logs) {
            sb.append("* ").append(s).append("\n");
        }
        sb.append("*\n");
        sb.append("********************************************************************************\n");
        return sb.toString();
    }

    protected String createFingerprintUrl(String hostName) {
        String fingerprintUrl = this.baseUrl + "GetFingerprint.action?hostName=" + hostName + this.fingerPrintRequestSuffix + "&" + VERSION_PARAM + "=" + BOOTSTRAP_VERSION + "&" + UUID_PARAM + "=" + this.agentUuid.toString();
        if (this.securityToken != null) {
            fingerprintUrl = fingerprintUrl + "&securityToken=" + this.securityToken;
        }
        if (this.agentId != null) {
            fingerprintUrl = fingerprintUrl + "&agentId=" + this.agentId;
        }
        return fingerprintUrl;
    }

    private void haveSomeSleep() {
        try {
            TimeUnit.SECONDS.sleep(this.serverPollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void validateBootstrapVersion(GetFingerprintResponse fingerprintResponse) throws ProtocolException {
        String bootstrapVersion = fingerprintResponse.getBootstrapVersion();
        if (bootstrapVersion == null) {
            throw new ProtocolException("Server has not specified Agent bootstrap version.  Please re-install the agent.");
        }
        if (!bootstrapVersion.equals("1")) {
            throw new ProtocolException("Server requires Agent bootstrap version " + bootstrapVersion + ".  Please re-install the agent.");
        }
    }

    private void updateBootstrapIfNecessary(AgentType agentBootstrapType) throws IOException {
        boolean isLatestBootstrap;
        if (agentBootstrapType == AgentType.REMOTE && System.getProperty(DISABLE_BOOTSTRAP_UPDATE) == null && !(isLatestBootstrap = BootstrapUpdater.ensureLatestBootstrap(this))) {
            log.info((Object)"Important agent classes have been updated, the agent will now terminate to pick up the latest changes.");
            System.exit(0);
        }
    }

    public String getServerFingerprint() {
        return this.serverFingerprint;
    }

    public long getInstanceFingerprint() {
        return this.instanceFingerprint;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Deprecated
    public String getAbsoluteURL(String relativeUrl) {
        String url = AgentContext.addParameter(this.baseUrl + relativeUrl, SERVER_FINGERPRINT_PARAM, this.serverFingerprint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requesting: " + url));
        }
        return url;
    }

    public String getAbsoluteUrl(String relativeUrl) {
        return this.baseUrl + relativeUrl;
    }

    public static String addParameter(String url, String name, String value) {
        return url + (url.contains("?") ? "&" : "?") + name + "=" + value;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.httpClientFactory.newHttpClient();
        }
        return this.httpClient;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public AgentType getAgentBootstrapType() {
        return this.agentBootstrapType;
    }

    @NotNull
    public UUID getAgentUuid() {
        return this.agentUuid;
    }

    public static void systemExit(@Nullable String reason, @Nullable Throwable throwable) {
        if (reason != null && throwable != null) {
            log.fatal((Object)("Agent encountered a fatal error: '" + reason + "'. Exiting."), throwable);
        } else if (reason != null) {
            log.fatal((Object)("Agent encountered a fatal error: '" + reason + "'. Exiting."), (Throwable)new Error());
        } else {
            log.fatal((Object)"Agent encountered a fatal error. Exiting.", (Throwable)new Error());
        }
        System.exit(1);
    }

    private String getHostname() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Cannot determine local host name; using \"localhost\".", (Throwable)e);
            hostName = "localhost";
        }
        return hostName;
    }

    private ClassLoader newClassLoader() throws IOException {
        File home = RemoteAgentHomeLocatorForBootstrap.getHome();
        File classPathDirectory = new File(home, "classpath");
        if (!classPathDirectory.exists() && !classPathDirectory.mkdirs()) {
            throw new IOException("Could not create directory '" + classPathDirectory.getAbsolutePath() + "'");
        }
        return ClasspathBuilder.getClassLoader(home, this);
    }
}

