/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class GetFingerprintResponse {
    private static final String USER_PROPERTY_PREFIX = "userProperty.";
    private ParserState parserState = ParserState.READING_KEY;
    private final StringBuilder key = new StringBuilder();
    private final StringBuilder value = new StringBuilder();
    private String bootstrapVersion;
    private String fingerprint;
    private String agentClassName;
    private final Map<String, String> userProperties = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetFingerprintResponse(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, "US-ASCII");
        try {
            while (this.parserState.parse(this, reader.read())) {
            }
        }
        finally {
            reader.close();
        }
    }

    private void processPair() throws UnsupportedEncodingException {
        String unencodedKey = URLDecoder.decode(this.key.toString(), "UTF-8");
        if (unencodedKey.startsWith(USER_PROPERTY_PREFIX)) {
            this.userProperties.put(unencodedKey.substring(USER_PROPERTY_PREFIX.length()), this.processValue());
        } else if (unencodedKey.equals("bootstrapVersion")) {
            this.bootstrapVersion = this.processValue();
        } else if (unencodedKey.equals("fingerprint")) {
            this.fingerprint = this.processValue();
        } else if (unencodedKey.equals("agentClassName")) {
            this.agentClassName = this.processValue();
        }
        this.key.setLength(0);
        this.value.setLength(0);
    }

    private String processValue() throws UnsupportedEncodingException {
        return URLDecoder.decode(this.value.toString(), "UTF-8");
    }

    public String getBootstrapVersion() {
        return this.bootstrapVersion;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getAgentClassName() {
        return this.agentClassName;
    }

    Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    private static enum ParserState {
        READING_KEY{

            @Override
            boolean parse(GetFingerprintResponse context, int c) throws IOException {
                if (c < 0) {
                    throw new EOFException();
                }
                if (c == 61) {
                    context.parserState = 1.READING_VALUE;
                    return true;
                }
                context.key.append((char)c);
                return true;
            }
        }
        ,
        READING_VALUE{

            @Override
            boolean parse(GetFingerprintResponse context, int c) throws UnsupportedEncodingException {
                if (c < 0) {
                    context.processPair();
                    return false;
                }
                if (c == 38) {
                    context.processPair();
                    context.parserState = 2.READING_KEY;
                    return true;
                }
                context.value.append((char)c);
                return true;
            }
        };


        abstract boolean parse(GetFingerprintResponse var1, int var2) throws IOException;
    }
}

