/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.log4j.Logger;

public class BambooHttpUtils {
    private static final Logger log = Logger.getLogger(BambooHttpUtils.class);

    private BambooHttpUtils() {
    }

    public static void consumeResponse(HttpMethodBase method) throws IOException {
        try {
            InputStream stream = method.getResponseBodyAsStream();
            if (stream != null) {
                stream.skip(Integer.MAX_VALUE);
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpMethodBase method) throws IOException {
        String string;
        InputStreamReader reader = null;
        StringWriter writer = new StringWriter();
        try {
            int n;
            reader = new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8");
            char[] buffer = new char[1024];
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            BambooHttpUtils.closeQuietly(reader);
            BambooHttpUtils.closeQuietly(writer);
            throw throwable;
        }
        BambooHttpUtils.closeQuietly(reader);
        BambooHttpUtils.closeQuietly(writer);
        return string;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

