/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class AgentBootstrap {
    private static final Logger log = Logger.getLogger(AgentBootstrap.class);
    protected final URL baseUrl;
    private volatile HttpClient httpClient;

    public static void main(String[] arguments) throws MalformedURLException {
        AgentTypeHolder.set((AgentType)AgentType.ELASTIC);
        AgentBootstrap.configureLogging();
        log.info((Object)("Starting Agent Bootstrap using Java " + System.getProperty("java.version") + " from " + System.getProperty("java.vm.vendor") + " Default charset: " + Charset.defaultCharset()));
        if (arguments.length == 1) {
            AgentBootstrap agentBootstrap = new AgentBootstrap(new URL(arguments[0]));
            agentBootstrap.run(AgentType.REMOTE);
        } else {
            StringBuffer message = new StringBuffer("Incorrect command line syntax.");
            if (arguments.length == 0) {
                message.append(" Single argument expected, no arguments were passed.");
            } else {
                message.append(" Only one argument allowed. ").append(arguments.length).append(" arguments were passed: ");
                for (String argument : arguments) {
                    message.append(argument).append(" ");
                }
            }
            log.error((Object)message);
            System.err.println(message);
            System.exit(1);
        }
    }

    protected static void configureLogging() {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            ((Appender)allAppenders.nextElement()).setLayout((Layout)new PatternLayout("%d %p [%t] [%c{1}] %m%n"));
        }
    }

    protected AgentBootstrap(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void run(AgentType type) {
        try {
            URL baseUrl = this.getProxyBaseURL();
            log.info((Object)("Agent bootstrap using baseUrl: " + baseUrl));
            AgentContext agentContext = new AgentContext(this.getHttpClient(), baseUrl, this.getFingerprintRequestSuffix(), type);
            agentContext.run();
        }
        catch (Throwable throwable) {
            throw AgentBootstrap.handleFatalException(throwable);
        }
    }

    protected boolean isHttpsBaseURL() {
        return "https".equals(this.baseUrl.getProtocol());
    }

    protected URL getProxyBaseURL() throws MalformedURLException {
        return this.baseUrl;
    }

    protected HttpClient getHttpClient() throws ClassNotFoundException, NoSuchAlgorithmException, KeyManagementException, MalformedURLException {
        if (this.httpClient == null) {
            this.httpClient = this.newHttpClient();
        }
        return this.httpClient;
    }

    protected HttpClient newHttpClient() throws MalformedURLException {
        return RemoteAgentHttpClient.newHttpClient();
    }

    static Error handleFatalException(Throwable throwable) {
        String FATAL_ERROR_MESSAGE = "Exiting due to fatal exception.";
        System.err.println("Exiting due to fatal exception.");
        throwable.printStackTrace();
        log.fatal((Object)"Exiting due to fatal exception.", throwable);
        System.exit(1);
        throw new Error("FATAL_ERROR_MESSAGE", throwable);
    }

    protected String getFingerprintRequestSuffix() {
        return "";
    }
}

