/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.log4j.Logger;

public class RemoteAgentHttpClient {
    private static final Logger log = Logger.getLogger(RemoteAgentHttpClient.class);
    private static final int HTTP_TRANSMISSION_TIMEOUT_SECONDS = 30;
    private static final int HTTP_CONNECTION_RETRIES = 30;

    public static HttpClient newHttpClient() throws ClassNotFoundException, MalformedURLException {
        return RemoteAgentHttpClient.newHttpClient(30, 30);
    }

    public static HttpClient newHttpClient(int timeoutSeconds, int retries) {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        manager.getParams().setConnectionTimeout((int)TimeUnit.SECONDS.toMillis(timeoutSeconds));
        manager.getParams().setSoTimeout((int)TimeUnit.SECONDS.toMillis(timeoutSeconds));
        DefaultHttpMethodRetryHandler retryhandler = new DefaultHttpMethodRetryHandler(retries, true){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                boolean rc = super.retryMethod(method, exception, executionCount);
                if (exception instanceof SocketTimeoutException) {
                    return executionCount < this.getRetryCount();
                }
                return rc;
            }
        };
        HttpClient client = new HttpClient((HttpConnectionManager)manager);
        client.getParams().setParameter("http.method.retry-handler", (Object)retryhandler);
        return client;
    }
}

