/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentBootstrap;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.AgentContextData;
import com.atlassian.bamboo.agent.bootstrap.AgentContextDataImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

class AgentRunner
implements Runnable {
    private static final Logger log = Logger.getLogger(AgentRunner.class);
    private final AgentContext context;
    private final String agentClassName;

    AgentRunner(AgentContext context, String agentClassName) {
        this.context = context;
        this.agentClassName = agentClassName;
    }

    @Override
    public void run() {
        try {
            AgentContextDataImpl contextData = new AgentContextDataImpl(this.context, Thread.currentThread().getContextClassLoader(), this.agentClassName);
            Class agentContextClass = contextData.loadClass(AgentContext.class.getName());
            Class agentClass = contextData.loadClass(this.agentClassName);
            Constructor constructor = agentContextClass.getConstructor(this.getClassForName(AgentContextData.class.getName()));
            Method method = agentClass.getDeclaredMethod("start", agentContextClass);
            Object agent = agentClass.newInstance();
            Object newAgentContext = constructor.newInstance(contextData);
            method.invoke(agent, newAgentContext);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"Cannot find methods necessary to recreate context and start the agent", (Throwable)e);
        }
        catch (Throwable throwable) {
            throw AgentBootstrap.handleFatalException(throwable);
        }
    }

    private Class getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
    }
}

