/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentBootstrapType;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.AgentContextData;
import java.util.Map;
import java.util.UUID;

public class AgentContextDataImpl
implements AgentContextData {
    private final AgentContext originalContext;
    private final String agentClassName;
    private final ClassLoader agentClassLoader;
    private final Class<AgentBootstrapType> agentBootstrapTypeClass;

    public AgentContextDataImpl(AgentContext originalContext, ClassLoader agentClassLoader, String agentClassName) throws ClassNotFoundException {
        this.originalContext = originalContext;
        this.agentClassLoader = agentClassLoader;
        this.agentClassName = agentClassName;
        this.agentBootstrapTypeClass = this.loadClass(AgentBootstrapType.class.getName());
    }

    @Override
    public ClassLoader agentClassLoader() {
        return this.agentClassLoader;
    }

    @Override
    public String baseUrl() {
        return this.originalContext.getBaseUrl();
    }

    @Override
    public String fingerprint() {
        return this.originalContext.getFingerprint();
    }

    @Override
    public Map<String, String> userProperties() {
        return this.originalContext.getUserProperties();
    }

    @Override
    public String agentClassName() {
        return this.agentClassName;
    }

    @Override
    public AgentBootstrapType agentBootstrapType() {
        return Enum.valueOf(this.agentBootstrapTypeClass, this.originalContext.getAgentBootstrapType().name());
    }

    @Override
    public UUID agentUuid() {
        return this.originalContext.getAgentUuid();
    }

    <T> Class<T> loadClass(String original) throws ClassNotFoundException {
        return Class.forName(original, true, this.agentClassLoader);
    }
}

