/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.AgentResourceEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentClassLoader
extends ClassLoader {
    private static final Logger log = Logger.getLogger(AgentClassLoader.class);
    private final AgentContext context;
    private final Map<String, URL> resourceUrlCache = new HashMap<String, URL>();
    private final Map<String, String> missedClassCache = new ConcurrentHashMap<String, String>();
    private final Lock resourcesLock = new ReentrantLock();

    AgentClassLoader(AgentContext context) throws IOException, ClassNotFoundException {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            byte[] bytes;
            int statusCode;
            String packageName;
            if (name.startsWith("java.")) {
                throw new ClassNotFoundException(name);
            }
            if (this.missedClassCache.containsKey(name)) {
                throw new ClassNotFoundException(name);
            }
            int lastDot = name.lastIndexOf(46);
            String string = packageName = lastDot < 0 ? "" : name.substring(0, lastDot);
            if (this.getPackage(packageName) == null) {
                String implVendor;
                String implVersion;
                String implTitle;
                String specVendor;
                String specVersion;
                String specTitle;
                int statusCode2;
                block27: {
                    GetMethod method = new GetMethod(this.context.getAbsoluteURL("GetPackage.action?className=" + name));
                    try {
                        this.context.getHttpClient().executeMethod((HttpMethod)method);
                        statusCode2 = method.getStatusCode();
                        if (statusCode2 == 200) {
                            InputStream responseBodyInputStream = method.getResponseBodyAsStream();
                            try {
                                ObjectInputStream objectInputStream = new ObjectInputStream(responseBodyInputStream);
                                try {
                                    specTitle = (String)objectInputStream.readObject();
                                    specVersion = (String)objectInputStream.readObject();
                                    specVendor = (String)objectInputStream.readObject();
                                    implTitle = (String)objectInputStream.readObject();
                                    implVersion = (String)objectInputStream.readObject();
                                    implVendor = (String)objectInputStream.readObject();
                                    break block27;
                                }
                                finally {
                                    objectInputStream.close();
                                }
                            }
                            finally {
                                responseBodyInputStream.close();
                            }
                        }
                        specTitle = null;
                        specVersion = null;
                        specVendor = null;
                        implTitle = null;
                        implVersion = null;
                        implVendor = null;
                    }
                    finally {
                        method.releaseConnection();
                    }
                }
                switch (statusCode2) {
                    case 200: {
                        this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
                    }
                    case 404: {
                        break;
                    }
                    default: {
                        throw AgentContext.httpException(statusCode2, "requesting package information for " + name);
                    }
                }
            }
            String absoluteURL = this.context.getAbsoluteURL("GetResource.action?name=" + name.replace('.', '/') + ".class");
            log.debug((Object)absoluteURL);
            GetMethod method = new GetMethod(absoluteURL);
            try {
                this.context.getHttpClient().executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
                bytes = statusCode == 200 ? method.getResponseBody() : null;
            }
            finally {
                method.releaseConnection();
            }
            switch (statusCode) {
                case 200: {
                    return this.tryDefineClass(name, bytes, 0, bytes.length);
                }
                case 404: {
                    this.missedClassCache.put(name, name);
                    throw new ClassNotFoundException(name);
                }
            }
            throw AgentContext.httpException(statusCode, "GET request for " + name);
        }
        catch (ClassNotFoundException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw this.context.panic(throwable);
        }
    }

    private Class<?> tryDefineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        try {
            return this.defineClass(name, b, off, len);
        }
        catch (ClassFormatError e) {
            log.error((Object)("Could not load class " + name));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String name) {
        this.resourcesLock.lock();
        try {
            if (this.resourceUrlCache.containsKey(name)) {
                URL uRL = this.resourceUrlCache.get(name);
                return uRL;
            }
        }
        finally {
            this.resourcesLock.unlock();
        }
        URL resourceUrl = this.checkIfResourceExists(name);
        this.resourcesLock.lock();
        try {
            this.resourceUrlCache.put(name, resourceUrl);
        }
        finally {
            this.resourcesLock.unlock();
        }
        return resourceUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL checkIfResourceExists(String name) {
        String url = this.context.getAbsoluteURL("GetResource.action?name=" + name);
        try {
            int statusCode;
            HeadMethod method = new HeadMethod(url);
            try {
                this.context.getHttpClient().executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
            }
            finally {
                method.releaseConnection();
            }
            switch (statusCode) {
                case 200: {
                    return new URL(url);
                }
                case 404: {
                    return null;
                }
            }
            throw AgentContext.httpException(statusCode, "HEAD request for " + name);
        }
        catch (Throwable throwable) {
            log.error((Object)("Exception in findResource method: " + throwable.getMessage() + ". Was finding requesting url: " + url), throwable);
            throw this.context.panic(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        try {
            URL[] resources;
            int statusCode;
            block15: {
                String url = this.context.getAbsoluteURL("GetResources.action?name=" + name);
                GetMethod method = new GetMethod(url);
                try {
                    this.context.getHttpClient().executeMethod((HttpMethod)method);
                    statusCode = method.getStatusCode();
                    if (statusCode == 200) {
                        InputStream inputStream = method.getResponseBodyAsStream();
                        try {
                            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                            try {
                                resources = (URL[])objectInputStream.readObject();
                                break block15;
                            }
                            finally {
                                objectInputStream.close();
                            }
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    resources = null;
                }
                finally {
                    method.releaseConnection();
                }
            }
            switch (statusCode) {
                case 200: {
                    return new AgentResourceEnumeration(this.context, resources);
                }
            }
            throw AgentContext.httpException(statusCode, "GetResources request for " + name);
        }
        catch (Throwable throwable) {
            throw this.context.panic(throwable);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.charAt(0) == '[' || name.endsWith("[]")) {
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }
}

