/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentClassLoader;
import com.atlassian.bamboo.agent.bootstrap.AgentRunner;
import com.atlassian.bamboo.agent.bootstrap.GetFingerprintResponse;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentContext {
    public static final String FINGERPRINT = "fingerprint";
    private static final Logger log = Logger.getLogger(AgentContext.class);
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String agentClassName;
    private final AgentClassLoader agentClassLoader;
    private final String fingerprint;
    private final Map<String, String> userProperties;

    static IOException httpException(int statusCode, String action) {
        return new IOException("HTTP status code " + statusCode + " received in response to " + action + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentContext(HttpClient httpClient, String baseUrl, String fingerPrintRequestSuffix) throws IOException, ClassNotFoundException {
        String hostName;
        this.httpClient = httpClient;
        this.baseUrl = !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
        try {
            hostName = Inet4Address.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Cannot determine local host name; using \"localhost\".", (Throwable)e);
            hostName = "localhost";
        }
        String fingerprintRequestUrl = this.baseUrl + "GetFingerprint.action?hostName=" + hostName + fingerPrintRequestSuffix;
        System.out.println("Requesting fingerprintRequestUrl: " + fingerprintRequestUrl);
        GetMethod method = new GetMethod(fingerprintRequestUrl);
        try {
            httpClient.executeMethod((HttpMethod)method);
            int statusCode = method.getStatusCode();
            if (statusCode != 200) {
                throw AgentContext.httpException(statusCode, "fingerprint request");
            }
            GetFingerprintResponse fingerprintResponse = new GetFingerprintResponse(method.getResponseBodyAsStream());
            String bootstrapVersion = fingerprintResponse.getBootstrapVersion();
            if (bootstrapVersion == null) {
                throw new ProtocolException("Server has not specified Agent boostrap version.  Please re-install the agent.");
            }
            if (!bootstrapVersion.equals("1")) {
                throw new ProtocolException("Server requires Agent bootstrap version " + fingerprintResponse.getBootstrapVersion() + ".  Please re-install the agent.");
            }
            this.fingerprint = fingerprintResponse.getFingerprint();
            this.agentClassName = fingerprintResponse.getAgentClassName();
            this.userProperties = fingerprintResponse.getUserProperties();
        }
        finally {
            method.releaseConnection();
        }
        this.agentClassLoader = new AgentClassLoader(this);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    protected void run() {
        Thread thread = new Thread(new AgentRunner(this, this.agentClassName));
        thread.setContextClassLoader(this.getAgentClassLoader());
        thread.start();
    }

    public String getAbsoluteURL(String relativeUrl) {
        String url = this.baseUrl + relativeUrl + (relativeUrl.contains("?") ? "&" : "?") + FINGERPRINT + "=" + this.fingerprint;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requesting: " + url));
        }
        return url;
    }

    ClassLoader getAgentClassLoader() {
        return this.agentClassLoader;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public Error panic(Throwable throwable) {
        log.fatal((Object)"Agent encountered fatal error.  Exiting.", throwable);
        System.exit(1);
        return null;
    }
}

