/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Predicate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DateUtils;
import org.jetbrains.annotations.NotNull;

public abstract class RecentLazyReference<T>
extends ResettableLazyReference<T> {
    private volatile RecentPredicate recentPredicate;

    public RecentLazyReference(long amount, TimeUnit unit) {
        this.setRecentPredicate(amount, unit);
    }

    public RecentLazyReference(RecentPredicate recentPredicate) {
        this.setRecentPredicate(recentPredicate);
    }

    public void setRecentPredicate(long amount, TimeUnit unit) {
        this.recentPredicate = new RecentPredicateImpl(amount, unit);
    }

    public void setRecentPredicate(RecentPredicate recentPredicate) {
        this.recentPredicate = recentPredicate;
    }

    public synchronized T get() {
        if (!this.recentPredicate.apply(new Date())) {
            this.reset();
        }
        return (T)super.get();
    }

    protected final T create() throws Exception {
        T object = this.createInstance();
        this.recentPredicate.reset();
        return object;
    }

    protected abstract T createInstance() throws Exception;

    private static class RecentPredicateImpl
    implements RecentPredicate {
        private final long amount;
        private final TimeUnit unit;
        private Date nextRefreshTime;

        public RecentPredicateImpl(long amount, @NotNull TimeUnit unit) {
            this.amount = amount;
            this.unit = unit;
        }

        @Override
        public void reset() {
            this.nextRefreshTime = DateUtils.addMilliseconds((Date)new Date(), (int)((int)this.unit.toMillis(this.amount)));
        }

        @Override
        public boolean apply(@NotNull Date date) {
            return this.nextRefreshTime != null && date.before(this.nextRefreshTime);
        }
    }

    public static interface RecentPredicate
    extends Predicate<Date> {
        public boolean apply(@NotNull Date var1);

        public void reset();
    }
}

