/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.typica;

import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypicaInstanceReservationDescription
implements InstanceReservationDescription {
    private final ReservationDescription.Instance reservationDescription;

    private TypicaInstanceReservationDescription(ReservationDescription.Instance reservationDescription) {
        this.reservationDescription = reservationDescription;
    }

    @NotNull
    public static Collection<InstanceReservationDescription> create(@NotNull List<ReservationDescription.Instance> instances) {
        return Collections2.transform(instances, (Function)new Function<ReservationDescription.Instance, InstanceReservationDescription>(){

            public InstanceReservationDescription apply(ReservationDescription.Instance reservationDescription) {
                return new TypicaInstanceReservationDescription(reservationDescription);
            }
        });
    }

    @Override
    public String getInstanceId() {
        return this.reservationDescription.getInstanceId();
    }

    @Override
    public String getAvailabilityZone() {
        return this.reservationDescription.getAvailabilityZone();
    }

    @Override
    public String getDnsName() {
        return this.reservationDescription.getDnsName();
    }

    @Override
    public String getState() {
        return this.reservationDescription.getState();
    }

    @Override
    public String getStateDescription() {
        return this.reservationDescription.getState() + " (" + this.reservationDescription.getStateCode() + ") for reason [" + this.reservationDescription.getReason() + "]";
    }
}

