/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.configuration;

import com.atlassian.aws.ec2.configuration.ImageData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageFileDao {
    private static final String PROP_ASSEMBLY_KEY = "assembly.key";
    private static final String PROP_ASSEMBLY_BUCKET = "assembly.bucket";
    private static final String PROP_IMAGE_US_E_1_S3_32 = "image.us_e.1.s3.32";

    private ImageFileDao() {
    }

    @NotNull
    public static ImageData readOrCreate(File amiIDFile) throws IOException {
        if (amiIDFile.canRead()) {
            return ImageFileDao.read(amiIDFile);
        }
        return ImageFileDao.read((InputStream)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ImageData read(File amiIDFile) throws IOException {
        FileInputStream fis = new FileInputStream(amiIDFile);
        try {
            ImageData imageData = ImageFileDao.read(fis);
            return imageData;
        }
        finally {
            fis.close();
        }
    }

    @NotNull
    private static ImageData read(@Nullable InputStream fis) throws IOException {
        ImageData allImageData = new ImageData();
        if (fis == null) {
            return allImageData;
        }
        Properties props = new Properties();
        props.load(fis);
        allImageData.setAssemblyBucketStem(props.getProperty(PROP_ASSEMBLY_BUCKET));
        allImageData.setAssemblyKey(props.getProperty(PROP_ASSEMBLY_KEY));
        ImageFileDao.addImageDefinition(allImageData, props, PROP_IMAGE_US_E_1_S3_32);
        return allImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageData readArtifact(@NotNull String artifactId) throws IOException {
        InputStream inputStream = ImageFileDao.class.getResourceAsStream("/" + artifactId + ".aws");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        try {
            ImageData data;
            ImageData imageData = data = ImageFileDao.read(inputStream);
            return imageData;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ImageData imageData, File amiIDFile) throws IOException {
        File parent = amiIDFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!amiIDFile.exists()) {
            amiIDFile.createNewFile();
        }
        Properties props = new Properties();
        ImageFileDao.putIfNotNull(props, PROP_ASSEMBLY_KEY, imageData.getAssemblyKey());
        ImageFileDao.putIfNotNull(props, PROP_ASSEMBLY_BUCKET, imageData.getAssemblyBucketStem());
        for (ImageData.ImageDefinition imageDefinition : imageData.getImageDefinitions()) {
            props.put(PROP_IMAGE_US_E_1_S3_32, imageDefinition.getImageId());
        }
        FileOutputStream out = new FileOutputStream(amiIDFile);
        try {
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }

    private static void putIfNotNull(@NotNull Properties properties, @NotNull String key, @Nullable String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    private static void addImageDefinition(ImageData allImageData, Properties props, String property) {
        String propertyValue = props.getProperty(property);
        if (propertyValue != null) {
            allImageData.add(new ImageData.ImageDefinition(propertyValue));
        }
    }
}

