/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.configuration;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImageData {
    private final List<ImageDefinition> imageDefinitions = Lists.newArrayList();
    private String assemblyBucketStem;
    private String assemblyKey;

    public String getAssemblyBucketStem() {
        return this.assemblyBucketStem;
    }

    public String getAssemblyBucket(AwsSupportConstants.Region region) {
        return ImageData.getNameForRegion(this.assemblyBucketStem, region);
    }

    public void setAssemblyBucketStem(String assemblyBucketStem) {
        this.assemblyBucketStem = assemblyBucketStem;
    }

    public String getAssemblyKey() {
        return this.assemblyKey;
    }

    public void setAssemblyKey(String assemblyKey) {
        this.assemblyKey = assemblyKey;
    }

    public ImageData add(ImageDefinition imageDefinition) {
        this.imageDefinitions.add(imageDefinition);
        return this;
    }

    @NotNull
    public List<ImageDefinition> getImageDefinitions() {
        return this.imageDefinitions;
    }

    @NotNull
    public static String getNameForRegion(@NotNull String nameStem, @NotNull AwsSupportConstants.Region region) {
        return nameStem + "-" + region.getNormalisedName();
    }

    public static class ImageDefinition {
        private final AwsSupportConstants.Region region;
        private final AwsSupportConstants.RootDeviceType rootDeviceType;
        private final AwsSupportConstants.ArchitectureType imageArchitecture;
        private String imageId;

        @Deprecated
        public ImageDefinition(@NotNull String imageId) {
            this(AwsSupportConstants.Region.US_EAST_1, AwsSupportConstants.RootDeviceType.S3, AwsSupportConstants.ArchitectureType.i386, imageId);
        }

        public ImageDefinition(@NotNull AwsSupportConstants.Region region, @NotNull AwsSupportConstants.RootDeviceType rootDeviceType, @NotNull AwsSupportConstants.ArchitectureType imageArchitecture, @NotNull String imageId) {
            this.region = region;
            this.rootDeviceType = rootDeviceType;
            this.imageArchitecture = imageArchitecture;
            this.imageId = imageId;
        }

        public String getImageId() {
            return this.imageId;
        }

        public void setImageId(String value) {
            this.imageId = value;
        }

        public AwsSupportConstants.Region getRegion() {
            return this.region;
        }

        public AwsSupportConstants.RootDeviceType getRootDeviceType() {
            return this.rootDeviceType;
        }

        public AwsSupportConstants.ArchitectureType getImageArchitecture() {
            return this.imageArchitecture;
        }
    }
}

