/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.Volume;
import com.atlassian.aws.AwsOmeCache;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.caches.Ec2CacheMissException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class VolumeCache
extends AwsOmeCache<Volume> {
    private static final Logger log = Logger.getLogger(VolumeCache.class);
    private final AmazonEC2Client ec2Client;

    public VolumeCache(AmazonEC2Client ec2Client, int maximumDataAge, TimeUnit maximumDataAgeUnit) {
        super(log, maximumDataAge, maximumDataAgeUnit);
        this.ec2Client = ec2Client;
    }

    public VolumeCache(AmazonEC2Client ec2Client) {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Volume> refreshAllData() {
        DescribeVolumesResult describeVolumesResult = this.ec2Client.describeVolumes();
        return describeVolumesResult.getVolumes();
    }

    @Override
    protected String toResourceId(Volume volume) {
        return volume.getVolumeId();
    }

    @Override
    protected void onResourceLookupFailure(String resourceId) {
        throw new Ec2CacheMissException(resourceId, AwsSupportConstants.ServiceErrorCode.INVALID_VOLUME_NOT_FOUND);
    }
}

