/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.atlassian.aws.AwsOmeCache;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.caches.Ec2CacheMissException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SpotRequestCache
extends AwsOmeCache<SpotInstanceRequest> {
    private static final Logger log = Logger.getLogger(SpotRequestCache.class);
    private final AmazonEC2 ec2Client;

    public SpotRequestCache(AmazonEC2Client ec2Client, long maximumDataAge, TimeUnit maximumDataAgeUnit) {
        super(log, maximumDataAge, maximumDataAgeUnit);
        this.ec2Client = ec2Client;
    }

    public SpotRequestCache(AmazonEC2Client ec2Client) {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<SpotInstanceRequest> refreshAllData() {
        DescribeSpotInstanceRequestsRequest describeSpotRequest = new DescribeSpotInstanceRequestsRequest();
        return this.ec2Client.describeSpotInstanceRequests(describeSpotRequest).getSpotInstanceRequests();
    }

    @Override
    protected void onResourceLookupFailure(String resourceId) {
        throw new Ec2CacheMissException(resourceId, AwsSupportConstants.ServiceErrorCode.INVALID_SPOT_INSTANCE_REQUEST_ID_NOT_FOUND);
    }

    @Override
    protected String toResourceId(SpotInstanceRequest resource) {
        return resource.getSpotInstanceRequestId();
    }
}

