/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.atlassian.aws.AwsOmeCache;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.caches.Ec2CacheMissException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class InstanceCache
extends AwsOmeCache<Instance> {
    private static final Logger log = Logger.getLogger(InstanceCache.class);
    private final AmazonEC2Client ec2Client;

    public InstanceCache(AmazonEC2Client ec2Client, int maximumDataAge, TimeUnit maximumDataAgeUnit) {
        super(log, maximumDataAge, maximumDataAgeUnit);
        this.ec2Client = ec2Client;
    }

    public InstanceCache(AmazonEC2Client ec2Client) {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Instance> refreshAllData() {
        DescribeInstancesResult describeInstancesResult = this.ec2Client.describeInstances();
        ArrayList instances = Lists.newArrayList();
        for (Reservation reservation : describeInstancesResult.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        return instances;
    }

    @Override
    protected String toResourceId(Instance instance) {
        return instance.getInstanceId();
    }

    @Override
    protected void onResourceLookupFailure(String resourceId) {
        throw new Ec2CacheMissException(resourceId, AwsSupportConstants.ServiceErrorCode.INVALID_INSTANCE_ID_NOT_FOUND);
    }
}

