/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.InstanceState;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwsSupportConstants {
    private static final Logger log = Logger.getLogger(AwsSupportConstants.class);
    public static final ImmutableMap<String, Region> AWS_STRING_TO_REGION = ImmutableMap.builder().put((Object)"US", (Object)Region.US_EAST_1).put((Object)"us-west-1", (Object)Region.US_WEST_1).put((Object)"EU", (Object)Region.EU_WEST_1).put((Object)"ap-northeast-1", (Object)Region.ASIA_PACIFIC_NE_1).put((Object)"ap-southeast-1", (Object)Region.ASIA_PACIFIC_SE_1).build();

    private AwsSupportConstants() {
    }

    @NotNull
    public static Region translateToRegion(@NotNull String region) {
        Region regionEnum = (Region)AWS_STRING_TO_REGION.get((Object)region);
        return regionEnum != null ? regionEnum : (Region)AwsSupportConstants.translateToEnum((String)region, (NameProvider[])Region.values());
    }

    @NotNull
    private static <T extends NameProvider> T translateToEnum(@NotNull String name, T ... values) {
        for (T someEnum : values) {
            if (!someEnum.getName().equals(name)) continue;
            return someEnum;
        }
        throw new IllegalArgumentException("Unable to translate [" + name + "] to enum " + values.getClass());
    }

    public static class SpotInstanceRequestType {
        public static final String ONE_TIME = "one-time";

        private SpotInstanceRequestType() {
        }
    }

    public static enum ServiceErrorCode {
        MAX_SPOT_INSTANCE_COUNT_EXCEEDED("MaxSpotInstanceCountExceeded"),
        INVALID_SPOT_INSTANCE_REQUEST_ID_NOT_FOUND("InvalidSpotInstanceRequestID.NotFound"),
        INVALID_INSTANCE_ID_NOT_FOUND("InvalidInstanceID.NotFound"),
        INVALID_VOLUME_NOT_FOUND("InvalidVolume.NotFound");

        private final String errorCodeString;

        private ServiceErrorCode(String errorCodeString) {
            this.errorCodeString = errorCodeString;
        }

        public String toString() {
            return this.errorCodeString;
        }

        public boolean is(@NotNull AmazonServiceException e) {
            return this.errorCodeString.equalsIgnoreCase(e.getErrorCode());
        }
    }

    public static enum SpotInstanceRequestState {
        OPEN("open"),
        ACTIVE("active"),
        CANCELLED("cancelled"),
        CLOSED("closed"),
        FAILED("failed");

        private final String stateName;

        private SpotInstanceRequestState(String stateName) {
            this.stateName = stateName;
        }

        public static boolean isFinal(@Nullable String state) {
            return CANCELLED.is(state) || CLOSED.is(state) || FAILED.is(state);
        }

        public boolean is(@Nullable String state) {
            return this.stateName.equals(state);
        }

        public String toString() {
            return this.stateName;
        }
    }

    public static enum InstanceStateName {
        SpotOpen(SpotInstanceRequestState.OPEN),
        SpotActive(SpotInstanceRequestState.ACTIVE),
        SpotCancelled(SpotInstanceRequestState.CANCELLED),
        SpotClosed(SpotInstanceRequestState.CLOSED),
        SpotFailed(SpotInstanceRequestState.FAILED),
        Pending(com.amazonaws.services.ec2.model.InstanceStateName.Pending),
        Running(com.amazonaws.services.ec2.model.InstanceStateName.Running),
        ShuttingDown(com.amazonaws.services.ec2.model.InstanceStateName.ShuttingDown),
        Terminated(com.amazonaws.services.ec2.model.InstanceStateName.Terminated),
        Stopping("stopping"),
        Stopped("stopped"),
        UNIDENTIFIED("unidentified");

        private final String state;

        private InstanceStateName(String state) {
            this.state = state;
        }

        private InstanceStateName(com.amazonaws.services.ec2.model.InstanceStateName state) {
            this.state = state.toString();
        }

        private InstanceStateName(SpotInstanceRequestState state) {
            this.state = state.stateName;
        }

        public String toString() {
            return this.state;
        }

        public static InstanceStateName fromValue(String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)value), (Object)"Value cannot be null or empty!");
            for (InstanceStateName name : InstanceStateName.values()) {
                if (!name.toString().equals(value)) continue;
                return name;
            }
            throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
        }

        public boolean is(@NotNull InstanceState state) {
            return this.state.equals(state.getName());
        }
    }

    public static enum InstanceAttribute {
        INSTANCE_INITIATED_SHUTDOWN_BEHAVIOUR("instanceInitiatedShutdownBehavior");

        private final String value;

        private InstanceAttribute(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum InstanceInitiatedShutdownBehaviour {
        STOP("stop"),
        TERMINATE("terminate");

        private final String behaviour;

        private InstanceInitiatedShutdownBehaviour(String behaviour) {
            this.behaviour = behaviour;
        }

        public String toString() {
            return this.behaviour;
        }
    }

    public static enum Region implements NameProvider
    {
        US_EAST_1("us-e1"),
        US_WEST_1("us-w1"),
        EU_WEST_1("eu-w1"),
        ASIA_PACIFIC_SE_1("ap-se1"),
        ASIA_PACIFIC_NE_1("ap-ne1");

        private final String name;

        private Region(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getNormalisedName() {
            return this.name;
        }
    }

    public static enum RootDeviceType implements NameProvider
    {
        S3("s3"),
        EBS("ebs");

        private final String name;

        private RootDeviceType(String awsName) {
            this.name = awsName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public static RootDeviceType fromAwsName(@NotNull String awsName) {
            return (RootDeviceType)AwsSupportConstants.translateToEnum((String)awsName, (NameProvider[])RootDeviceType.values());
        }
    }

    public static enum ArchitectureType implements NameProvider
    {
        x86_64("x86_64"),
        i386("i386");

        private final String name;

        private ArchitectureType(String awsName) {
            this.name = awsName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public static ArchitectureType fromAwsName(@NotNull String awsName) {
            return (ArchitectureType)AwsSupportConstants.translateToEnum((String)awsName, (NameProvider[])ArchitectureType.values());
        }
    }

    public static interface NameProvider {
        public String getName();
    }
}

