/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.Reservation;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AwsInstanceReservationDescription
implements InstanceReservationDescription {
    private static final Logger log = Logger.getLogger(AwsInstanceReservationDescription.class);
    private final Instance instance;
    private final InstancePaymentType instancePaymentType;

    public AwsInstanceReservationDescription(Instance instance, InstancePaymentType instancePaymentType) {
        this.instance = instance;
        this.instancePaymentType = instancePaymentType;
    }

    @NotNull
    public static Collection<InstanceReservationDescription> create(Reservation reservation) {
        List instances = reservation.getInstances();
        return Collections2.transform((Collection)instances, (Function)new Function<Instance, InstanceReservationDescription>(){

            public InstanceReservationDescription apply(@NotNull Instance instance) {
                return new AwsInstanceReservationDescription(instance, InstancePaymentType.REGULAR);
            }
        });
    }

    @Override
    public String getInstanceId() {
        return this.instance.getInstanceId();
    }

    @Override
    public String getAvailabilityZone() {
        return this.instance.getPlacement().getAvailabilityZone();
    }

    @Override
    public String getDnsName() {
        return this.instance.getPublicDnsName();
    }

    @Override
    public String getState() {
        return this.instance.getState().getName();
    }

    @Override
    public String getStateDescription() {
        InstanceState state = this.instance.getState();
        return state.getName() + " (" + state.getCode() + ") for reason [" + this.instance.getStateTransitionReason() + "]";
    }
}

