/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.CancelledSpotInstanceRequest;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EBSVolume;
import com.atlassian.aws.ec2.EBSVolumeManager;
import com.atlassian.aws.ec2.EC2InstanceListener;
import com.atlassian.aws.ec2.EC2InstanceState;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.awssdk.AwsInstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSpotInstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.EC2Image;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xerox.amazonws.ec2.EC2Exception;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteEC2InstanceImpl
implements RemoteEC2Instance {
    private static final Logger log = Logger.getLogger(RemoteEC2InstanceImpl.class);
    private static final int DEFAULT_TIMEOUT = 300;
    private static final int SHUTDOWN_TIMEOUT_IN_SECONDS = 300;
    private final AtomicInteger successiveSupervisionFailures = new AtomicInteger();
    private int spotRequestTimeoutSeconds = 300;
    private InstancePaymentType instancePaymentType;
    private InstanceLauncher regularInstanceLauncher = new AwsInstanceLauncher();
    private final EC2Image image;
    private final String keyName;
    private final List<String> securityGroupIds;
    private final Object userData;
    private final EC2InstanceType instanceType;
    private final String requestedAvailabilityZone;
    private final int pollPeriodInSeconds;
    private final int maxSuccessiveSupervisionFailures;
    private final AWSAccount awsAccount;
    private final int startupTimeoutInSeconds;
    private final EC2InstanceListener listener;
    private final ScheduledExecutorService scheduledExecutorService;
    private double spotInstanceBid;
    public StopWatch startupStopWatch = new StopWatch();
    private final List<Throwable> backgroundThrowables;
    private final EBSVolumeManager volumeManager;
    private final AtomicBoolean startCalled = new AtomicBoolean();
    private final Runnable launcherTask = new CatchingRunnableDecorator("backgroundStart()", new Runnable(){

        @Override
        public void run() {
            RemoteEC2InstanceImpl.this.backgroundStart();
        }
    });
    private final Runnable supervisor = new CatchingRunnableDecorator("backgroundSupervise()", new Runnable(){

        @Override
        public void run() {
            RemoteEC2InstanceImpl.this.backgroundSupervise();
        }
    });
    private ScheduledFuture<?> scheduledTermination;
    private final AtomicBoolean isBeingTerminated = new AtomicBoolean();
    private final Runnable terminator = new CatchingRunnableDecorator("terminator()", new Runnable(){
        public boolean isSpotRequestInactive;

        private boolean terminateInstance() {
            if (RemoteEC2InstanceImpl.this.instanceId == null) {
                return true;
            }
            log.info((Object)("Bamboo is requesting that EC2 instance " + RemoteEC2InstanceImpl.this.instanceId + " be shut down."));
            TerminateInstancesRequest terminateInstacesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{RemoteEC2InstanceImpl.this.instanceId});
            TerminateInstancesResult terminateInstancesResult = RemoteEC2InstanceImpl.this.awsAccount.getAwsClient().terminateInstances(terminateInstacesRequest);
            List terminatingInstances = terminateInstancesResult.getTerminatingInstances();
            for (InstanceStateChange terminatingInstance : terminatingInstances) {
                log.info((Object)("Requested transition of EC2 instance " + terminatingInstance.getInstanceId() + ", state will change from : " + terminatingInstance.getPreviousState() + " to " + terminatingInstance.getCurrentState() + ")"));
            }
            return !terminatingInstances.isEmpty();
        }

        private boolean cancelSpotRequest() {
            DescribeSpotInstanceRequestsResult describeSpotInstanceRequestsResult;
            if (RemoteEC2InstanceImpl.this.instanceId != null || this.isSpotRequestInactive || RemoteEC2InstanceImpl.this.spotInstanceRequestId == null) {
                return true;
            }
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest = new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{RemoteEC2InstanceImpl.this.spotInstanceRequestId});
            try {
                describeSpotInstanceRequestsResult = RemoteEC2InstanceImpl.this.awsAccount.getAwsClient().describeSpotInstanceRequests(describeSpotInstanceRequestsRequest);
            }
            catch (AmazonServiceException e) {
                if (AwsSupportConstants.ServiceErrorCode.INVALID_SPOT_INSTANCE_REQUEST_ID_NOT_FOUND.is(e)) {
                    return true;
                }
                throw e;
            }
            SpotInstanceRequest describedSpotRequest = (SpotInstanceRequest)Iterables.getOnlyElement((Iterable)describeSpotInstanceRequestsResult.getSpotInstanceRequests());
            if (AwsSupportConstants.SpotInstanceRequestState.isFinal(describedSpotRequest.getState())) {
                String describedInstanceId = describedSpotRequest.getInstanceId();
                if (StringUtils.isNotBlank((String)describedInstanceId) && RemoteEC2InstanceImpl.this.instanceId == null) {
                    RemoteEC2InstanceImpl.this.instanceId = describedInstanceId;
                }
                return true;
            }
            CancelSpotInstanceRequestsRequest cancelRequest = new CancelSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{RemoteEC2InstanceImpl.this.spotInstanceRequestId});
            CancelSpotInstanceRequestsResult cancelSpotInstanceRequestsResult = RemoteEC2InstanceImpl.this.awsAccount.getAwsClient().cancelSpotInstanceRequests(cancelRequest);
            List cancelledSpotInstanceRequests = cancelSpotInstanceRequestsResult.getCancelledSpotInstanceRequests();
            for (CancelledSpotInstanceRequest cancelledSpotInstanceRequest : cancelledSpotInstanceRequests) {
                log.info((Object)("Requested cancellation of spot request " + cancelledSpotInstanceRequest.getSpotInstanceRequestId()));
            }
            return !cancelledSpotInstanceRequests.isEmpty();
        }

        @Override
        public void run() {
            log.debug((Object)("Started termination task for instance/spot request " + RemoteEC2InstanceImpl.this.getSensibleId()));
            try {
                this.isSpotRequestInactive = this.cancelSpotRequest();
            }
            catch (Throwable throwable) {
                log.warn((Object)("Failed to order cancellation  of spot request " + RemoteEC2InstanceImpl.this.spotInstanceRequestId + ".  Will retry."), throwable);
            }
            boolean isInstanceTerminated = false;
            try {
                isInstanceTerminated = this.terminateInstance();
            }
            catch (Throwable throwable) {
                log.warn((Object)("Failed to order cancellation  of spot request " + RemoteEC2InstanceImpl.this.spotInstanceRequestId + ".  Will retry."), throwable);
            }
            if (isInstanceTerminated && this.isSpotRequestInactive) {
                boolean mayInterruptIfRunning = false;
                RemoteEC2InstanceImpl.this.scheduledTermination.cancel(false);
                log.debug((Object)("Instance " + RemoteEC2InstanceImpl.this.getSensibleId() + " has been terminated"));
            }
        }
    });
    private volatile String instanceId = null;
    private volatile String spotInstanceRequestId = null;
    private volatile ScheduledFuture<?> supervisorJob;
    private volatile EC2InstanceState state = EC2InstanceState.INITIAL;
    private long deadline;
    private volatile Date launchTime;
    private volatile String dnsName;
    private volatile String availabilityZone;

    public RemoteEC2InstanceImpl(EC2Image image, String keyName, List<String> securityGroupIds, Object userData, EC2InstanceType instanceType, String requestedAvailabilityZone, int pollPeriodInSeconds, int maxSuccessiveSupervisionFailures, int startupTimeoutInSeconds, EC2InstanceListener listener, AWSAccount awsAccount, ScheduledExecutorService scheduledExecutorService, List<Throwable> backgroundThrowables, EBSVolumeManager volumeManager) {
        this.image = image;
        this.keyName = keyName;
        this.securityGroupIds = securityGroupIds;
        this.userData = userData;
        this.maxSuccessiveSupervisionFailures = maxSuccessiveSupervisionFailures;
        this.awsAccount = awsAccount;
        this.instanceType = instanceType == null ? EC2InstanceType.DEFAULT : instanceType;
        this.requestedAvailabilityZone = requestedAvailabilityZone;
        this.pollPeriodInSeconds = pollPeriodInSeconds;
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
        this.listener = listener;
        this.scheduledExecutorService = scheduledExecutorService;
        this.backgroundThrowables = backgroundThrowables;
        this.volumeManager = volumeManager;
    }

    @Override
    public EC2InstanceType getInstanceType() {
        return this.instanceType;
    }

    @Override
    public Date getLaunchTime() {
        return this.launchTime;
    }

    @Override
    public String getDnsName() {
        return this.dnsName;
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public void setSpotInstanceBid(double spotInstanceBid) {
        this.spotInstanceBid = spotInstanceBid;
    }

    @Override
    public void setSpotRequestTimeoutSeconds(int spotRequestTimeoutSeconds) {
        this.spotRequestTimeoutSeconds = spotRequestTimeoutSeconds;
    }

    @Override
    public void start() {
        if (!this.startCalled.compareAndSet(false, true)) {
            throw new IllegalStateException("Already started.");
        }
        this.scheduledExecutorService.execute(this.launcherTask);
    }

    @Override
    public void asyncTerminate() {
        if (!this.startCalled.get()) {
            throw new IllegalStateException("Not started.");
        }
        try {
            if (this.isBeingTerminated.compareAndSet(false, true)) {
                this.scheduledTermination = this.scheduledExecutorService.scheduleWithFixedDelay(this.terminator, 0L, 5L, TimeUnit.MINUTES);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Unable to schedule termination: ", (Throwable)e);
            this.isBeingTerminated.set(false);
            throw e;
        }
    }

    @Override
    public boolean isBeingTerminated() {
        return this.scheduledTermination != null;
    }

    @Override
    public List<EBSVolume> getAttachedVolumes() throws AWSException, IOException {
        return this.volumeManager.getAttachedVolumes(this);
    }

    InstanceReservationDescription describeInstance() {
        if (this.instanceId == null && this.spotInstanceRequestId == null) {
            throw new IllegalStateException("The instance has neither an instance id nor a spot request id");
        }
        if (this.instanceId == null) {
            SpotInstanceRequest describedSpotRequest = this.describeSpotRequest();
            if (StringUtils.isNotBlank((String)describedSpotRequest.getInstanceId())) {
                this.instanceId = describedSpotRequest.getInstanceId();
                describedSpotRequest.setState(AwsSupportConstants.InstanceStateName.SpotActive.toString());
                log.info((Object)("Spot instance request " + this.spotInstanceRequestId + " is now active as instance " + this.instanceId));
            }
            return new AwsSpotInstanceReservationDescription(describedSpotRequest);
        }
        Collection<Instance> describeInstancesResult = this.awsAccount.describeInstances(this.getInstanceId());
        Instance instance = (Instance)Iterables.getOnlyElement(describeInstancesResult);
        this.launchTime = instance.getLaunchTime();
        return new AwsInstanceReservationDescription(instance, this.instancePaymentType);
    }

    private SpotInstanceRequest describeSpotRequest() {
        Collection<SpotInstanceRequest> describeSpotInstanceRequestsResult = this.awsAccount.describeSpotInstanceRequests(this.spotInstanceRequestId);
        return (SpotInstanceRequest)Iterables.getOnlyElement(describeSpotInstanceRequestsResult);
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getSensibleId() {
        return this.instanceId != null ? this.instanceId : this.spotInstanceRequestId;
    }

    void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    private void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    boolean isDeadlinePassed() {
        return System.currentTimeMillis() > this.deadline;
    }

    AWSException unexpectedStateException(InstanceReservationDescription instance) {
        return new AWSException("EC2 instance " + this.getSensibleId() + " in an unexpected state " + instance.getStateDescription());
    }

    public void handleStateChange(InstanceReservationDescription instance, AwsSupportConstants.InstanceStateName newState) {
        long timeElapsed = TimeUnit.MILLISECONDS.toSeconds(this.startupStopWatch.getTime());
        String msg = null;
        switch (newState) {
            case SpotActive: {
                log.info((Object)("Spot request fulfilled after " + timeElapsed + " seconds."));
                this.setSupervisionState(EC2InstanceState.PENDING, msg, null);
                break;
            }
            case SpotCancelled: 
            case SpotClosed: 
            case SpotFailed: {
                String statusDescription = "Spot request " + ((AwsSpotInstanceReservationDescription)instance).getSpotInstanceRequestId() + " state is " + (Object)((Object)newState) + " after " + timeElapsed + " seconds,";
                if (timeElapsed > (long)this.spotRequestTimeoutSeconds) {
                    log.info((Object)(statusDescription + ", falling back to a regular instance."));
                    this.launchInstance(this.regularInstanceLauncher);
                    break;
                }
                log.info((Object)(statusDescription + ", assuming this was a manual cancellation."));
                this.setSupervisionState(EC2InstanceState.TERMINATED, msg, null);
                break;
            }
            case Running: {
                this.instanceId = instance.getInstanceId();
                this.availabilityZone = instance.getAvailabilityZone();
                this.dnsName = instance.getDnsName();
                msg = "Bamboo has detected that EC2 instance " + this.getInstanceId() + " is now running at " + this.dnsName;
                this.setSupervisionState(EC2InstanceState.RUNNING, msg, null);
                break;
            }
            case Stopping: {
                msg = "Bamboo has detected that EC2 EBS-backed instance " + this.getInstanceId() + " is stopping.";
                this.setSupervisionState(EC2InstanceState.STOPPING, msg, null);
                break;
            }
            case Stopped: {
                msg = "Bamboo has detected that EC2 EBS-backed instance " + this.getInstanceId() + " has stopped.";
                this.setSupervisionState(EC2InstanceState.STOPPED, msg, null);
                break;
            }
            case ShuttingDown: {
                msg = "Bamboo has detected that EC2 instance " + this.getInstanceId() + " is shutting down.";
                this.setDeadline(300);
                this.setSupervisionState(EC2InstanceState.SHUTTING_DOWN, msg, null);
                break;
            }
            case Terminated: {
                msg = "EC2 instance " + this.getInstanceId() + " has terminated.";
                this.setSupervisionState(EC2InstanceState.TERMINATED, msg, null);
            }
        }
        if (msg != null) {
            log.info(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void backgroundStart() {
        log.trace((Object)"Entered backgroundStart()");
        InstanceLauncher launcher = this.spotInstanceBid > 0.0 ? new AwsSpotInstanceLauncher() : this.regularInstanceLauncher;
        try {
            if (this.launchInstance(launcher)) {
                this.supervisorJob = this.scheduledExecutorService.scheduleWithFixedDelay(this.supervisor, 0L, this.pollPeriodInSeconds, TimeUnit.SECONDS);
            }
        }
        finally {
            log.trace((Object)"Finished backgroundStart()");
        }
    }

    private boolean launchInstance(InstanceLauncher launcher) {
        EC2InstanceState initialState;
        String details;
        InstanceReservationDescription instance;
        this.startupStopWatch.reset();
        this.startupStopWatch.start();
        try {
            Collection<InstanceReservationDescription> instances = launcher.call();
            instance = (InstanceReservationDescription)Iterables.getOnlyElement(instances);
        }
        catch (Throwable throwable) {
            String details2 = "EC2 instance order failed.";
            log.error((Object)"EC2 instance order failed.", throwable);
            this.setSupervisionState(EC2InstanceState.FAILED_TO_START, "EC2 instance order failed.", throwable);
            return false;
        }
        if (this.instancePaymentType == InstancePaymentType.SPOT) {
            details = "Placed spot request " + this.getSensibleId();
            initialState = EC2InstanceState.BIDDING;
        } else {
            this.instanceId = instance.getInstanceId();
            details = "Ordered EC2 instance " + this.getSensibleId();
            initialState = EC2InstanceState.PENDING;
        }
        this.availabilityZone = instance.getAvailabilityZone();
        log.info((Object)details);
        this.setSupervisionState(initialState, details, null);
        return true;
    }

    private LaunchSpecification createLaunchSpecification(String imageId) throws IOException {
        LaunchSpecification launchSpecification = new LaunchSpecification().withImageId(imageId).withKeyName(this.keyName).withSecurityGroups((Collection)Lists.newArrayList(this.securityGroupIds)).withInstanceType(this.instanceType.getAwsInstanceType().toString());
        EC2Utils.setUserData(launchSpecification, this.userData);
        return launchSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void backgroundSupervise() {
        block7: {
            log.trace((Object)"Entered backgroundSupervise()");
            try {
                if (this.state.isFinal()) {
                    throw new IllegalStateException((Object)((Object)this.state) + " is a final state.");
                }
                try {
                    this.state.supervise(this);
                    this.successiveSupervisionFailures.set(0);
                }
                catch (Throwable throwable) {
                    if (this.successiveSupervisionFailures.incrementAndGet() > this.maxSuccessiveSupervisionFailures) {
                        log.error((Object)("Request for current status of EC2 instance " + this.getInstanceId() + " failed after " + this.maxSuccessiveSupervisionFailures + " attempts.  No further attempts will be made."), throwable);
                        this.state.supervisionFailure(this, throwable);
                        break block7;
                    }
                    log.warn((Object)("Request for current status of EC2 instance " + this.getInstanceId() + " failed, try " + this.successiveSupervisionFailures.get() + ".  Will retry later."), throwable);
                }
            }
            finally {
                log.trace((Object)"Finished backgroundSupervise()");
            }
        }
    }

    void setSupervisionState(final EC2InstanceState newState, final @Nullable String details, final @Nullable Throwable throwable) {
        if (!newState.equals((Object)this.state)) {
            final EC2InstanceState previousState = this.state;
            this.state = newState;
            if (newState.isFinal() && this.supervisorJob != null) {
                log.debug((Object)"Cancelling supervisor");
                this.supervisorJob.cancel(false);
            }
            new CatchingRunnableDecorator("Listener " + this.listener, new Runnable(){

                @Override
                public void run() {
                    RemoteEC2InstanceImpl.this.listener.ec2InstanceStateChanged(RemoteEC2InstanceImpl.this, previousState, newState, details, throwable);
                }
            }).run();
        }
    }

    private void setDeadline(int timeoutInSeconds) {
        this.deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutInSeconds);
    }

    @Override
    public InstancePaymentType getInstancePaymentType() {
        return this.instancePaymentType;
    }

    @Override
    public void addTag(@NotNull String key, @NotNull String value) {
        CreateTagsRequest createTagsRequest = new CreateTagsRequest().withResources(new String[]{this.instanceId}).withTags(new Tag[]{new Tag(key, value)});
        this.awsAccount.getAwsClient().createTagsAsync(createTagsRequest);
    }

    public void setRegularInstanceLauncher(InstanceLauncher regularInstanceLauncher) {
        this.regularInstanceLauncher = regularInstanceLauncher;
    }

    class AwsSpotInstanceLauncher
    implements InstanceLauncher {
        AwsSpotInstanceLauncher() {
        }

        @Override
        public Collection<InstanceReservationDescription> call() throws IOException, EC2Exception {
            List placedSpotInstanceRequest;
            block4: {
                Date spotRequestValidityEnd = DateUtils.addSeconds((Date)new Date(), (int)RemoteEC2InstanceImpl.this.spotRequestTimeoutSeconds);
                RemoteEC2InstanceImpl.this.setDeadline(2 * RemoteEC2InstanceImpl.this.spotRequestTimeoutSeconds);
                RequestSpotInstancesRequest requestSpotInstance = new RequestSpotInstancesRequest().withSpotPrice(Double.toString(RemoteEC2InstanceImpl.this.spotInstanceBid)).withInstanceCount(Integer.valueOf(1)).withValidUntil(spotRequestValidityEnd).withAvailabilityZoneGroup(RemoteEC2InstanceImpl.this.availabilityZone).withType("one-time").withLaunchSpecification(RemoteEC2InstanceImpl.this.createLaunchSpecification(RemoteEC2InstanceImpl.this.image.getId()));
                placedSpotInstanceRequest = Collections.emptyList();
                try {
                    placedSpotInstanceRequest = RemoteEC2InstanceImpl.this.awsAccount.getAwsClient().requestSpotInstances(requestSpotInstance).getSpotInstanceRequests();
                }
                catch (AmazonServiceException e) {
                    if (AwsSupportConstants.ServiceErrorCode.MAX_SPOT_INSTANCE_COUNT_EXCEEDED.is(e)) break block4;
                    throw e;
                }
            }
            if (placedSpotInstanceRequest.isEmpty()) {
                log.warn((Object)"Unable to place a spot instance request, proceeding with regular instance order");
                return RemoteEC2InstanceImpl.this.regularInstanceLauncher.call();
            }
            RemoteEC2InstanceImpl.this.instancePaymentType = InstancePaymentType.SPOT;
            if (placedSpotInstanceRequest.size() > 1) {
                log.warn((Object)("A request for a single instance resulted in " + placedSpotInstanceRequest.size() + " being placed. Ignoring spurious spot instance requests."));
            }
            RemoteEC2InstanceImpl.this.spotInstanceRequestId = ((SpotInstanceRequest)Iterables.getOnlyElement((Iterable)placedSpotInstanceRequest)).getSpotInstanceRequestId();
            return AwsSpotInstanceReservationDescription.create(placedSpotInstanceRequest);
        }
    }

    class AwsInstanceLauncher
    implements InstanceLauncher {
        AwsInstanceLauncher() {
        }

        @Override
        public Collection<InstanceReservationDescription> call() throws IOException {
            RemoteEC2InstanceImpl.this.instancePaymentType = InstancePaymentType.REGULAR;
            RemoteEC2InstanceImpl.this.setDeadline(RemoteEC2InstanceImpl.this.startupTimeoutInSeconds);
            String imageId = RemoteEC2InstanceImpl.this.image.getId();
            RunInstancesRequest runInstancesRequest = new RunInstancesRequest().withImageId(imageId).withKeyName(RemoteEC2InstanceImpl.this.keyName).withSecurityGroups((Collection)RemoteEC2InstanceImpl.this.securityGroupIds).withInstanceType(RemoteEC2InstanceImpl.this.instanceType.getAwsInstanceType().toString()).withPlacement(new Placement().withAvailabilityZone(RemoteEC2InstanceImpl.this.requestedAvailabilityZone)).withInstanceInitiatedShutdownBehavior(AwsSupportConstants.InstanceInitiatedShutdownBehaviour.TERMINATE.toString()).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1)).withClientToken(RandomStringUtils.randomAlphanumeric((int)64));
            EC2Utils.setUserData(runInstancesRequest, RemoteEC2InstanceImpl.this.userData);
            log.info((Object)("Ordering EC2 instance of image " + imageId));
            RunInstancesResult runInstancesResult = RemoteEC2InstanceImpl.this.awsAccount.getAwsClient().runInstances(runInstancesRequest);
            return AwsInstanceReservationDescription.create(runInstancesResult.getReservation());
        }
    }

    private static interface InstanceLauncher {
        public Collection<InstanceReservationDescription> call() throws IOException, EC2Exception;
    }

    private class CatchingRunnableDecorator
    implements Runnable {
        private final String description;
        private final Runnable runnable;

        public CatchingRunnableDecorator(String description, Runnable runnable) {
            this.description = description;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            block2: {
                try {
                    log.trace((Object)("Entering " + this.description));
                    this.runnable.run();
                }
                catch (Throwable throwable) {
                    log.error((Object)("Exception during " + this.description), throwable);
                    if (RemoteEC2InstanceImpl.this.backgroundThrowables == null) break block2;
                    RemoteEC2InstanceImpl.this.backgroundThrowables.add(throwable);
                }
            }
        }
    }
}

