/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.atlassian.aws.ec2.EC2Instance;
import com.atlassian.aws.ec2.LocalEC2InstanceImpl;
import com.atlassian.aws.ec2.configuration.EC2Image;
import com.atlassian.aws.ec2.configuration.EC2ImageImpl;
import com.atlassian.urlfetcher.URLFetcherUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.KeyStore;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EC2Utils {
    public static Gson gson;
    private static final String API_BASE_URL = "http://169.254.169.254/2008-02-01/";
    static final String USER_DATA_URL = "http://169.254.169.254/2008-02-01/user-data";
    static final String META_DATA_BASE_URL = "http://169.254.169.254/2008-02-01/meta-data/";
    private static final String AMI_ID_URL = "http://169.254.169.254/2008-02-01/meta-data/ami-id";

    private EC2Utils() {
    }

    public static EC2Instance getLocalEC2Instance() throws IOException {
        return new LocalEC2InstanceImpl();
    }

    public static void setUserData(@NotNull LaunchConfiguration launchConfiguration, @Nullable Object userData) throws IOException {
        if (userData != null) {
            launchConfiguration.setUserData(EC2Utils.serializeToBytes(userData));
        }
    }

    public static void setUserData(@NotNull LaunchSpecification launchSpecification, @Nullable Object userData) throws IOException {
        if (userData != null) {
            launchSpecification.setUserData(EC2Utils.serializeToString(userData));
        }
    }

    public static void setUserData(@NotNull RunInstancesRequest runInstancesRequest, @Nullable Object userData) throws IOException {
        if (userData != null) {
            runInstancesRequest.setUserData(EC2Utils.serializeToString(userData));
        }
    }

    public static <T> T getUserData(Class<T> aClass) throws IOException, ClassNotFoundException {
        String json = URLFetcherUtils.getURLFetcher().fetchString(USER_DATA_URL);
        return (T)gson.fromJson(json, aClass);
    }

    public static EC2Image getCurrentImage() throws IOException {
        String amiId = URLFetcherUtils.getURLFetcher().fetchString(AMI_ID_URL);
        if (amiId == null) {
            throw new IOException("Could not obtain AMI ID.");
        }
        return new EC2ImageImpl(amiId);
    }

    private static byte[] serializeToBytes(Object userData) {
        return Base64.encodeBase64((byte[])gson.toJson(userData).getBytes());
    }

    private static String serializeToString(Object userData) {
        return new String(EC2Utils.serializeToBytes(userData));
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(KeyStore.class, (Object)new KeyStoreMarshaller());
        gson = builder.create();
    }

    private static class KeyStoreMarshaller
    implements JsonSerializer<KeyStore>,
    JsonDeserializer<KeyStore> {
        static final String KEY_STORE_PASSWORD = "bamboo";

        private KeyStoreMarshaller() {
        }

        public JsonElement serialize(KeyStore keyStore, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((JsonElement)new JsonPrimitive(keyStore.getType()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                keyStore.store(byteArrayOutputStream, KEY_STORE_PASSWORD.toCharArray());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            String keyStoreContents = new String(Base64.encodeBase64((byte[])byteArrayOutputStream.toByteArray()));
            jsonArray.add((JsonElement)new JsonPrimitive(keyStoreContents));
            return jsonArray;
        }

        public KeyStore deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray array = jsonElement.getAsJsonArray();
            try {
                JsonElement keyStoreType = array.get(0);
                JsonElement keyStoreContent = array.get(1);
                KeyStore keyStore = KeyStore.getInstance(keyStoreType.getAsString());
                byte[] decoded = Base64.decodeBase64((byte[])keyStoreContent.getAsString().getBytes());
                keyStore.load(new ByteArrayInputStream(decoded), KEY_STORE_PASSWORD.toCharArray());
                return keyStore;
            }
            catch (Exception e) {
                throw new JsonParseException("Could not deserialize keystore", (Throwable)e);
            }
        }
    }
}

