/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.xerox.amazonws.ec2.InstanceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EC2InstanceType {
    T1Micro("Micro", "613 MB memory\nUp to 2 EC2 Compute Units (for short periodic bursts)\nEBS storage only\n32-bit or 64-bit platform\nI/O Performance: Low", com.amazonaws.services.ec2.model.InstanceType.T1Micro),
    M1_SMALL("Small", "1.7 GB memory\n1 EC2 Compute Unit (1 virtual core with 1 EC2 Compute Unit)\n160 GB instance storage\n32-bit platform\nI/O Performance: Moderate", com.amazonaws.services.ec2.model.InstanceType.M1Small),
    M1_LARGE("Large", "7.5 GB memory\n4 EC2 Compute Units (2 virtual cores with 2 EC2 Compute Units each)\n850 GB instance storage\n64-bit platform\nI/O Performance: High", com.amazonaws.services.ec2.model.InstanceType.M1Large),
    M1_XLARGE("Extra Large", "15 GB memory\n8 EC2 Compute Units (4 virtual cores with 2 EC2 Compute Units each)\n1,690 GB instance storage\n64-bit platform\nI/O Performance: High", com.amazonaws.services.ec2.model.InstanceType.M1Xlarge),
    M2Xlarge("High-Memory Extra Large Instance", "17.1 GB of memory\n6.5 EC2 Compute Units (2 virtual cores with 3.25 EC2 Compute Units each)\n420 GB of instance storage\n64-bit platform\nI/O Performance: Moderate", com.amazonaws.services.ec2.model.InstanceType.M2Xlarge),
    M22xlarge("High-Memory Double Extra Large Instance", "34.2 GB of memory\n13 EC2 Compute Units (4 virtual cores with 3.25 EC2 Compute Units each)\n850 GB of instance storage\n64-bit platform\nI/O Performance: High", com.amazonaws.services.ec2.model.InstanceType.M22xlarge),
    M24xlarge("High-Memory Quadruple Extra Large Instance", "68.4 GB of memory\n26 EC2 Compute Units (8 virtual cores with 3.25 EC2 Compute Units each)\n1690 GB of instance storage\n64-bit platform\nI/O Performance: High", com.amazonaws.services.ec2.model.InstanceType.M24xlarge),
    C1_MEDIUM("High-CPU Medium", "1.7 GB of memory\n5 EC2 Compute Units (2 virtual cores with 2.5 EC2 Compute Units each)\n350 GB of instance storage\n32-bit platform\nI/O Performance: Moderate", com.amazonaws.services.ec2.model.InstanceType.C1Medium),
    C1_XLARGE("High-CPU Extra Large", "7 GB of memory\n20 EC2 Compute Units (8 virtual cores with 2.5 EC2 Compute Units each)\n1690 GB of instance storage\n64-bit platform\nI/O Performance: High", com.amazonaws.services.ec2.model.InstanceType.C1Xlarge),
    Cc14xlarge("Cluster Compute Quadruple Extra Large Instance", "23 GB of memory\n33.5 EC2 Compute Units (2 x Intel Xeon X5570, quad-core \u201cNehalem\u201d architecture)\n1690 GB of instance storage\n64-bit platform\nI/O Performance: Very High (10 Gigabit Ethernet)", com.amazonaws.services.ec2.model.InstanceType.Cc14xlarge),
    Cg14xlarge("Cluster GPU Quadruple Extra Large Instance", "22 GB of memory\n33.5 EC2 Compute Units (2 x Intel Xeon X5570, quad-core \u201cNehalem\u201d architecture)\n2 x NVIDIA Tesla \u201cFermi\u201d M2050 GPUs\n1690 GB of instance storage\n64-bit platform\nI/O Performance: Very High (10 Gigabit Ethernet)", com.amazonaws.services.ec2.model.InstanceType.Cg14xlarge);

    public static final EC2InstanceType DEFAULT;
    private final String name;
    private final String description;
    private final com.amazonaws.services.ec2.model.InstanceType apiParameterValue;

    private EC2InstanceType(String name, String description, com.amazonaws.services.ec2.model.InstanceType apiParameterValue) {
        this.name = name;
        this.description = description;
        this.apiParameterValue = apiParameterValue;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public com.amazonaws.services.ec2.model.InstanceType getAwsInstanceType() {
        return this.apiParameterValue;
    }

    public String toString() {
        return this.name;
    }

    public InstanceType getTypicaInstanceType() {
        return InstanceType.getTypeFromString((String)this.apiParameterValue.toString());
    }

    @Nullable
    public static EC2InstanceType convertFromTypica(@NotNull InstanceType typicaInstanceType) {
        for (EC2InstanceType ourInstanceType : EC2InstanceType.values()) {
            if (!ourInstanceType.getAwsInstanceType().toString().equals(typicaInstanceType.getTypeId())) continue;
            return ourInstanceType;
        }
        return null;
    }

    static {
        DEFAULT = M1_SMALL;
    }
}

