/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.RemoteEC2InstanceImpl;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.xerox.amazonws.ec2.EC2Exception;
import org.apache.log4j.Logger;

public enum EC2InstanceState {
    INITIAL,
    BIDDING{

        @Override
        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            InstanceReservationDescription instance = impl.describeInstance();
            EC2InstanceState.handleState(AwsSupportConstants.InstanceStateName.SpotOpen, instance, impl, new AwsSupportConstants.InstanceStateName[]{AwsSupportConstants.InstanceStateName.SpotClosed, AwsSupportConstants.InstanceStateName.SpotCancelled, AwsSupportConstants.InstanceStateName.SpotFailed, AwsSupportConstants.InstanceStateName.SpotActive});
            if (impl.isDeadlinePassed()) {
                throw new AWSException("Deadline passed waiting for spot request " + impl.getSensibleId() + " to be realised.");
            }
        }

        @Override
        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String msg = "Spot request " + impl.getSensibleId() + " has not been realised.  Attempting to terminate.";
            EC2InstanceState.terminate(impl, throwable, msg);
            impl.setSupervisionState(FAILED_TO_START, msg, throwable);
        }
    }
    ,
    PENDING{

        @Override
        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            InstanceReservationDescription instance = impl.describeInstance();
            EC2InstanceState.handleState(AwsSupportConstants.InstanceStateName.Pending, instance, impl, new AwsSupportConstants.InstanceStateName[]{AwsSupportConstants.InstanceStateName.Running, AwsSupportConstants.InstanceStateName.Stopping, AwsSupportConstants.InstanceStateName.Stopped, AwsSupportConstants.InstanceStateName.ShuttingDown, AwsSupportConstants.InstanceStateName.Terminated});
            if (impl.isDeadlinePassed()) {
                throw new AWSException("Deadline passed waiting for EC2 instance " + impl.getInstanceId() + " to start.");
            }
        }

        @Override
        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String msg = "EC2 instance " + impl.getInstanceId() + " failed to start.  Attempting to terminate.";
            EC2InstanceState.terminate(impl, throwable, msg);
            impl.setSupervisionState(FAILED_TO_START, msg, throwable);
        }
    }
    ,
    FAILED_TO_START,
    RUNNING{

        @Override
        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            InstanceReservationDescription instance = impl.describeInstance();
            EC2InstanceState.handleState(AwsSupportConstants.InstanceStateName.Running, instance, impl, new AwsSupportConstants.InstanceStateName[]{AwsSupportConstants.InstanceStateName.Stopping, AwsSupportConstants.InstanceStateName.Stopped, AwsSupportConstants.InstanceStateName.ShuttingDown, AwsSupportConstants.InstanceStateName.Terminated});
        }

        @Override
        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "Failure in EC2 instance " + impl.getInstanceId() + ".  Attempting to terminate.";
            EC2InstanceState.terminate(impl, throwable, details);
            impl.setSupervisionState(UNKNOWN, details, throwable);
        }
    }
    ,
    STOPPING{

        @Override
        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            InstanceReservationDescription instance = impl.describeInstance();
            EC2InstanceState.handleState(AwsSupportConstants.InstanceStateName.Stopping, instance, impl, new AwsSupportConstants.InstanceStateName[]{AwsSupportConstants.InstanceStateName.Stopped, AwsSupportConstants.InstanceStateName.Running, AwsSupportConstants.InstanceStateName.ShuttingDown, AwsSupportConstants.InstanceStateName.Terminated});
        }

        @Override
        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "Failure in EC2 instance " + impl.getInstanceId() + ".";
            log.error((Object)details, throwable);
            impl.setSupervisionState(UNKNOWN, details, throwable);
        }
    }
    ,
    STOPPED{

        @Override
        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            InstanceReservationDescription instance = impl.describeInstance();
            EC2InstanceState.handleState(AwsSupportConstants.InstanceStateName.Stopped, instance, impl, new AwsSupportConstants.InstanceStateName[]{AwsSupportConstants.InstanceStateName.Stopping, AwsSupportConstants.InstanceStateName.Running, AwsSupportConstants.InstanceStateName.ShuttingDown, AwsSupportConstants.InstanceStateName.Terminated});
        }

        @Override
        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "Failure in EC2 instance " + impl.getInstanceId() + ".";
            log.error((Object)details, throwable);
            impl.setSupervisionState(UNKNOWN, details, throwable);
        }
    }
    ,
    SHUTTING_DOWN{

        @Override
        void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
            InstanceReservationDescription instance = impl.describeInstance();
            EC2InstanceState.handleState(AwsSupportConstants.InstanceStateName.ShuttingDown, instance, impl, new AwsSupportConstants.InstanceStateName[]{AwsSupportConstants.InstanceStateName.Terminated});
        }

        @Override
        void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
            String details = "EC2 instance " + impl.getInstanceId() + " failed to shut down.";
            log.error((Object)details, throwable);
            impl.setSupervisionState(UNKNOWN, details, throwable);
        }
    }
    ,
    TERMINATED,
    UNKNOWN;

    private static final Logger log;

    private static void terminate(RemoteEC2InstanceImpl impl, Throwable throwable, String details) {
        log.error((Object)details, throwable);
        try {
            impl.asyncTerminate();
        }
        catch (Throwable throwable2) {
            log.error((Object)("Failed to terminate EC2 instance " + impl.getInstanceId()), throwable2);
        }
    }

    private static void handleState(AwsSupportConstants.InstanceStateName previousState, InstanceReservationDescription instance, RemoteEC2InstanceImpl handler, AwsSupportConstants.InstanceStateName ... validStates) throws AWSException {
        AwsSupportConstants.InstanceStateName currentState;
        try {
            currentState = AwsSupportConstants.InstanceStateName.fromValue(instance.getState());
        }
        catch (IllegalArgumentException e) {
            throw handler.unexpectedStateException(instance);
        }
        if (currentState == previousState) {
            return;
        }
        for (AwsSupportConstants.InstanceStateName validState : validStates) {
            if (currentState != validState) continue;
            handler.handleStateChange(instance, currentState);
            return;
        }
        throw handler.unexpectedStateException(instance);
    }

    final boolean isFinal() {
        return this == FAILED_TO_START || this == TERMINATED || this == UNKNOWN;
    }

    void supervise(RemoteEC2InstanceImpl impl) throws EC2Exception, AWSException {
        throw new UnsupportedOperationException((Object)((Object)this) + " is not implemented.");
    }

    void supervisionFailure(RemoteEC2InstanceImpl impl, Throwable throwable) {
        throw new UnsupportedOperationException((Object)((Object)this) + " is not implemented.");
    }

    static {
        log = Logger.getLogger(EC2InstanceState.class);
    }
}

